<?php

namespace Diamond\Modules\AdminSettings;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Core\ModuleController;
use Core\Template\Template;
use Diamond\Config\Content;
use Diamond\Config\Counters;
use Diamond\Config\Mail;
use Diamond\Config\Mailing;
use Diamond\Config\Main;
use Diamond\Repositories\GuestBook\GuestBookCriteria;
use Diamond\Repositories\GuestBook\GuestBookRepository;

/**
 * Description of AdminSettings
 *
 * @author Admin
 */
class AdminSettings extends ModuleController
{

    public $group = 'main';

    public function __construct(private FormBuilder         $formBuilder,
                                private ControlBuilder      $controlBuilder,
                                private Main                $confMain,
                                private Mail                $confMail,
                                private Counters            $confCounters,
                                private Content             $content,
                                private GuestBookRepository $bookRepository,
                                private Template            $template,
                                private Mailing             $mailing)
    {
    }

    public function process(): string
    {
        return $this->{'process' . $this->group}();
    }

    protected function processMain(): string
    {

        $form = $this->formBuilder->buildSettingsForm($this->confMain, "main")->setClass('panel-body form-horizontal form-padding');

        $builder = $this->controlBuilder;

        //$form->addHeader("Основные");

        $form->addField(
            $builder->buildInputSmall("site_name"), "Название сайта", "required"
        );
        $form->addField(
            $builder->buildInputSmall("email_admin"), "Email администратора", "required|mail"
        );
        $form->addField(
            $builder->buildInput("copyright"), "Копирайт"
        );

        $form->addField(
            $builder->buildTextArea("signature"), 'Имя отправителя и подпись', [], 'автоматически добавляется в конец каждого письма'
        );
//        $form->addField(
//            $builder->buildDropdownUniform("colorTheme", [
//                'default' => 'Amanda Classic',
//                'contrast' => 'Контраст',
//                'blueline' => 'Синяя',
//                'greenline' => 'Зеленая'
//            ]), 'Цветовая схема', "required", 'Для административной части сайта'
//        );

//        $form->addField(
//            $builder->buildTextArea("signature_info"), 'Подпись для автоматических ответов', [], 'будет добавлена к email уведомлению'
//        );


        return $form->render();
    }

    protected function processEmail(): string
    {
        $this->template->addScript($this->render('javascript'));

        $form = $this->formBuilder->buildSettingsForm($this->confMail, 'mail')
            ->setClass('panel-body form-horizontal form-padding');
        $builder = $this->controlBuilder;

        $form->addField(
            $builder->buildDropdownUniform('smtp_email', array(
                'mail' => 'php mail',
                'sendmail' => 'sendmail',
                'smtp' => 'smtp'
            )), 'Использовать протокол'
        );

        $form->addField(
            $builder->buildInputSmall('mail_from'), 'Адрес отправителя', null,
            'электронная почта лица-отправителя'
        );

        $form->addField(
            $builder->buildInputSmall('name_from'), 'Имя отправителя', null,
            'имя лица-отправителя'
        );

        $form->addSubHeader('SMTP');

        $form->addField(
            $builder->buildInputSmall('smtp_host'), 'SMTP-сервер', null, 'пример smtp.yandex.ru'
        );
        $form->addField(
            $builder->buildInputSmall('smtp_user'), 'Имя пользователя SMTP'
        );
        $form->addField(
            $builder->buildInputPassword('smtp_pass'), 'Пароль для SMTP'
        );
        $form->addField(
            $builder->buildInputLittle('smtp_port'), 'Порт SMTP-сервера'
        );
        $form->addField(
            $builder->buildInputLittle('smtp_timeout'), 'SMTP тайм-аут (в секундах)'
        );
        $form->addField(
            $builder->buildDropdownYNUniform('smtp_ssl'), 'Защита SMTP'
        );

        $form->addSubHeader('Sendmail');

        $form->addField(
            $builder->buildInputSmall('mailpath'), 'Серверный путь к Sendmail'
        );

        $form->addFieldControl(
            $builder
                ->buildButton('connect', 'Проверить подключение')
                ->setClass('btn btn-warning')
                ->setOnClick("testConnectEmail()")
        );


        return $form->render();
    }

    protected function processSeo(): string
    {
        $form = $this->formBuilder->buildSettingsForm($this->confMain, "seo")
            ->setClass('panel-body form-horizontal form-padding');

        $builder = $this->controlBuilder;


        $form->addField(
            $builder->buildInput("site_title"), "Заголовок сайта", "required", "основной метатег title для всех страниц"
        );
        $form->addField(
            $builder->buildTextArea("site_description"), 'Описание сайта', [], 'основной метатег description для всех страниц'
        );
        $form->addField(
            $builder->buildTextArea("site_keywords"), 'Ключевые слова', [], 'основной метатег keywords для всех страниц'
        );

//        $form->addField(
//                $builder->buildInputLittle("url_suffix"), 'Суффикс страницы', [], 'будет добавляться ко всем страницам'
//        );

        $form->addField(
            $builder->buildInputLittle("title_separator"), 'Разделитель заголовка', [], 'используется в title страницы'
        );

        $form->addField(
            $builder->buildDropdownUniform('title_direction', array(
                '' => 'слева на право',
                'RTL' => 'справа на лево'
            )), 'Направление заголовка', null, 'направление при формировании title'
        );

        return $form->render();
    }

    protected function processContent(): string
    {
        $form = $this->formBuilder->buildSettingsForm($this->content, 'content')->setClass('panel-body form-horizontal form-padding');

        $builder = $this->controlBuilder;

        $books = $this->bookRepository->findByCriteria(
            GuestBookCriteria::create()
        )->getDropdownList();

        $form
            ->addField(
                $builder->buildInput('sliderImagesPath'),
                'Путь к изображениям слайдера',
                null,
                'Путь относительно upload директории'
            )
            ->addField(
                $builder->buildDropdownUniform("bookSiteReview", $books), 'Книга отзывов сайта', "required"
            )
            ->addField(
                $builder->buildDropdownUniform("bookProductReview", $books), 'Книга отзывов для товаров'
            )
            ->addField(
                $builder->buildDropdownYNUniform("siteCommentDefaultPubliched"), 'Публикация отзывов по умолчанию'
            );

        return $form->render();
    }

    protected function processOther(): string
    {
        $form = $this->formBuilder->buildSettingsForm($this->confMain, 'content')->setClass('panel-body form-horizontal form-padding');

        $builder = $this->controlBuilder;

        $form
            ->addSubHeader("Google Recaptcha")
            ->addField(
                $builder->buildInputSmall("reCaptchaKey"), "Ключ"
            )
            ->addField(
                $builder->buildInputSmall("secretKey"), "Секретный ключ"
            );


        $form
            ->addSubHeader("Безопасность")
            ->addField(
                $builder->buildInputLittle("sessionLife"), 'Время жизни сессии авторизации', [], 'в часах, Внимание! увеличение не безопасно.'
            );

        $form
            ->addSubHeader("Служебные")
            ->addField(
                $builder->buildDropdownYNUniform('compress_output'), 'Сжатие страниц', null, 'уменьшает размер и кол-во запросов js и css'
            )
            ->addField(
                $builder->buildDropdownYNUniform('offline'), 'Сайт выключен', null, 'будет показана системная offline страница'
            )
            ->addField(
                $builder->buildDropdownUniform('profiler', array(
                    'N' => 'нет',
                    'client' => 'сайт',
                    'admin' => 'админ. часть',
                    'all' => 'везде'
                )), 'Активация профайлера', null, 'будет показана отладочая информация'
            );
        return $form->render();
    }

    protected function processCounters(): string
    {

        $form = $this->formBuilder->buildSettingsForm($this->confCounters, "counters");

        $builder = $this->controlBuilder;

        $form->addField(
            $builder->buildTextArea("top_counters", 8), 'Счетчики в начале страницы', [], 'сразу после открывающего тега body'
        );
        $form->addField(
            $builder->buildTextArea("bootom_counters", 8), 'Счетчики в подвале страницы', [], 'перед закрывающим тегом body'
        );
        return $form->render();
    }

    protected function processMailing(): string
    {

        $form = $this->formBuilder->buildSettingsForm($this->mailing, "mailing");

        $builder = $this->controlBuilder;

        $form->addField(
            $builder->buildInputSmall("partsSend"), 'Сколько писем отправлять за раз', ['required'], "1 интерация раз в 15мин"
        );
        return $form->render();
    }

}
