<?php

namespace Diamond\Modules\AdminMailing;


use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\MailingPreparation\MailingCook;
use Diamond\Domain\MailingTemplate\Contracts\MailingTemplateEntityInterface;
use Diamond\Repositories\MailingTemplate\MailingTemplateCriteria;
use Diamond\Repositories\MailingTemplate\MailingTemplateRepository;
use DiamondTable\TableFactory;

/**
 * Description of AdminMailing
 *
 * @author Diamond Code Generator
 */
class AdminMailing extends \Core\ModuleController
{


    protected $mailingTemplateRepository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $mailingCook;

    public function __construct(MailingTemplateRepository $mailingTemplateRepository,
                                TableFactory $tableFactory,
                                ControlBuilder $controlBuilder,
                                MailingCook $mailingCook)
    {
        $this->mailingTemplateRepository = $mailingTemplateRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->mailingCook = $mailingCook;
    }

    /**
     * @return string
     * @throws \ReflectionException
     */
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->mailingTemplateRepository, MailingTemplateCriteria::create());

        $table
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование шаблона'))
            )
            ->addColumn(
                (new ColumnTable('subject', 'Тема сообщения'))
            )
            ->addColumn(
                (new ColumnTable('body', 'Содержимое шаблона'))
                    ->setFormat($this, 'formatBody')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatActions')
            );

        $help = implode('<br/>', $this->mailingCook->getSnippets());

        $table
            ->addField(
                $this->controlBuilder->buildInput('name'), true
            )
            ->addField(
                $this->controlBuilder->buildInput('subject'), true, null,'Будет использовать в теме email сообщения'
            )
            ->addField(
                $this->controlBuilder->buildTextEditor('body'), true, null, $help
            );

        return $table->render();
    }


    public function formatActions(MailingTemplateEntityInterface $maling): string
    {
        return $this->controlBuilder->buildActionMenuAdmin([], $maling->getId())->render();
    }

    /**
     * @param MailingTemplateEntityInterface $template
     * @return string
     */
    public function formatBody(MailingTemplateEntityInterface $template): string
    {
        return trim(str_replace(
            array('\r\n', '\n'), '',
            \Diamond\Helpers\Text::characterLimiter(strip_tags($template->getBody()), 80)));
    }
}