<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 14.06.2020
 * Time: 23:38
 */

namespace Diamond\Factory;

use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Http\Message\ServerRequestInterface;
use Symfony\Bridge\PsrHttpMessage\Factory\PsrHttpFactory;
use Symfony\Component\HttpFoundation\Request;

class ServerRequest
{

    /**
     * @param Request $request
     * @return ServerRequestInterface
     */
    public static function build(Request $request): ServerRequestInterface
    {
        $psr17Factory = new Psr17Factory();
        $psrHttpFactory = new PsrHttpFactory($psr17Factory, $psr17Factory, $psr17Factory, $psr17Factory);
        return $psrHttpFactory->createRequest($request);
    }

}