<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 14.08.2020
 * Time: 22:14
 */

namespace Diamond\Repositories\User;


use Core\Security\Access;
use Diamond\Domain\User\Contracts\UserCriteriaInterface;
use Diamond\Domain\User\Contracts\UserEntityInterface;
use Diamond\Domain\User\UserCollection;
use Diamond\Infrastructure\Models\User\User;
use Diamond\Infrastructure\Models\User\UserQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class UserRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public function __construct(private Access $access)
    {
    }


    /**
     * @return EntityInterface|UserEntityInterface
     */
    public static function createEntity(): \Repo\EntityInterface
    {
        return new User();
    }

    /**
     * @param PaginationInterface|UserCriteriaInterface $criteria
     * @param ModelCriteria|UserQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria

            ->_if($criteria->getBlocked() !== null)
            ->filterByUsrDelete($criteria->getBlocked()===true?1:0)
            ->_endif()
            ->_if($criteria->getFilterByEmail()!==null)
            ->filterByEmail($criteria->getFilterByEmail())
            ->_endif()
            ->_if($criteria->getSearchByEmail()!==null)
            ->filterByEmail('%' . $criteria->getSearchByEmail() . '%', Criteria::LIKE)
            ->_endif()

            ->_if($criteria->getSearchByName()!==null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif()

            ->_if($criteria->getFilterByGroupId()!==null)
            ->filterByGroupId($criteria->getFilterByGroupId())
            ->_endif()

            ->_if($criteria->getSortByGroupId()!==null)
            ->orderById($criteria->getSortByGroupId())
            ->_endif()


            ->_if($criteria->getSortByName()!==null)
            ->orderByName($criteria->getSortByName())
            ->_endif()

            ->_if($criteria->getSortByEmail()!==null)
            ->orderByEmail($criteria->getSortByEmail())
            ->_endif()
        ;


    }




    protected function createCollection(): CollectionInterface
    {
        return new UserCollection();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return UserQuery::create();
    }

    /**
     * @param User $entity
     * @return void
     */
    public function save(EntityInterface $entity): void
    {
        parent::save($entity);
        $this->access->deleteAllRoleForUser($entity->getId());
        $this->access->addRoleForUser($entity->getId(),$entity->getUserGroup()->getGrpCode());
    }

    public function delete(EntityInterface $entity): void
    {
        $this->access->deleteAllRoleForUser($entity->getId());
        parent::delete($entity);
    }

}