<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 14.08.2020
 * Time: 22:17
 */

namespace Diamond\Repositories\User;


use Diamond\Domain\User\Contracts\UserCriteriaInterface;
use Repo\Concrete\AbstractCriteria;
use Repo\PaginationInterface;

class UserCriteria extends AbstractCriteria implements UserCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var int|null
     */
    protected $filterByGroupId;

    /**
     * @var string|null
     */
    protected $filterByEmail;
    
    /**
     * @var string|null
     */
    protected $searchByEmail;

    /**
     * @var string|null
     */
    protected $sortById;

    /**
     * @var string|null
     */
    protected $sortByGroupId;

    /**
     * @var string|null
     */
    protected $sortByName;
    /**
     * @var string|null
     */
    protected $sortByEmail;

    protected bool|null $blocked = null;

    /**
     * @return UserCriteria
     */
    public static function create()
    {
        return new self();
    }

    /**
     * @return bool|null
     */
    public function getBlocked(): ?bool
    {
        return $this->blocked;
    }

    /**
     * @param bool|null $blocked
     * @return UserCriteria
     */
    public function setBlocked(?bool $blocked): UserCriteriaInterface
    {
        $this->blocked = $blocked;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByEmail(): ?string
    {
        return $this->filterByEmail;
    }

    /**
     * @param string|null $filterByEmail
     * @return UserCriteria
     */
    public function setFilterByEmail(?string $filterByEmail): UserCriteriaInterface
    {
        $this->filterByEmail = $filterByEmail;
        return $this;
    }


    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return UserCriteria
     */
    public function setSearchByName(?string $searchByName): UserCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    public function getFilterByGroupId(): ?int
    {
        return $this->filterByGroupId;
    }

    /**
     * @param mixed $filterByGroupId
     * @return UserCriteria
     */
    public function setFilterByGroupId($filterByGroupId)
    {
        $this->filterByGroupId = $filterByGroupId;
        return $this;
    }

    public function getSearchByEmail(): ?string
    {
        return $this->searchByEmail;
    }

    /**
     * @param string|null $searchByEmail
     * @return UserCriteria
     */
    public function setSearchByEmail(?string $searchByEmail): UserCriteriaInterface
    {
        $this->searchByEmail = $searchByEmail;
        return $this;
    }

    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    public function getSortByEmail(): ?string
    {
        return $this->sortByEmail;
    }


    /**
     * @param string|null $sortByName
     * @return UserCriteria
     */
    public function setSortByName(?string $sortByName): UserCriteriaInterface
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @param string|null $sortByEmail
     * @return UserCriteria
     */
    public function setSortByEmail(?string $sortByEmail): UserCriteriaInterface
    {
        $this->sortByEmail = $sortByEmail;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getSortByGroupId(): ?string
    {
        return $this->sortByGroupId;
    }

    /**
     * @param string|null $sortByGroupId
     * @return UserCriteria
     */
    public function setSortByGroupId(?string $sortByGroupId): UserCriteriaInterface
    {
        $this->sortByGroupId = $sortByGroupId;
        return $this;
    }


}