<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 31.08.2020
 * Time: 22:25
 */

namespace Diamond\Repositories\PromoBlock;

use Diamond\Domain\PromoBlock\PromoBlockCollection;
use Diamond\Infrastructure\Models\Promoblock\Promoblock;
use Diamond\Infrastructure\Models\Promoblock\PromoblockQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class PromoBlockRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    /**
     * @return EntityInterface|PromoBlockCriteria
     */
    public static function createEntity(): EntityInterface
    {
        return new Promoblock();
    }

    protected function createCollection(): CollectionInterface
    {
        return new PromoBlockCollection();
    }

    protected function createQuery(): ModelCriteria
    {
        return PromoblockQuery::create();
    }


    /**
     * @param PaginationInterface|PromoBlockCriteria $criteria
     * @param ModelCriteria|PromoblockQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByUrlMask() !== null)
            ->filterByPrmUrlMask($criteria->getFilterByUrlMask())
            ->_endif()
            ->_if($criteria->getFilterByCode() !== null)
            ->filterByCode($criteria->getFilterByCode())
            ->_endif()
            ->_if($criteria->getSearchByCode() !== null)
            ->filterByCode('%' . $criteria->getSearchByCode() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getSearchByTitle() !== null)
            ->filterByTitle('%' . $criteria->getSearchByTitle() . '%', Criteria::LIKE)
            ->_endif();
    }
}