<?php

namespace Diamond\Repositories\PromoBlock;

use Diamond\Domain\PromoBlock\Contracts\PromoBlockCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

/**
 * Class PromoBlockCriteria
 * @package Diamond\Repositories\PromoBlock
 */
class PromoBlockCriteria extends AbstractCriteria implements PromoBlockCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $filterByUrlMask;

    /**
     * @var string|null
     */
    protected $filterByCode;

    /**
     * @var string|null
     */
    protected $searchByCode;

    /**
     * @var string|null
     */
    protected $searchByTitle;

    protected $filterBySiteId;

    /**
     * @return PromoBlockCriteria
     */
    public static function create()
    {
        return new self;
    }

    /**
     * @return string|null
     */
    public function getFilterByUrlMask(): ?string
    {
        return $this->filterByUrlMask;
    }

    /**
     * @param string|null $filterByUrlMask
     * @return PromoBlockCriteria
     */
    public function setFilterByUrlMask(?string $filterByUrlMask): PromoBlockCriteria
    {
        $this->filterByUrlMask = $filterByUrlMask;
        return $this;
    }

    /**
     * @param int|null $domainId
     * @return $this|mixed
     */
    public function setFilterBySiteId(?int $domainId)
    {
        $this->filterBySiteId = $domainId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterBySiteId(): ?int
    {
        return $this->filterBySiteId;
    }


    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    /**
     * @param string|null $filterByCode
     * @return PromoBlockCriteria
     */
    public function setFilterByCode(?string $filterByCode): PromoBlockCriteria
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSearchByCode(): ?string
    {
        return $this->searchByCode;
    }

    /**
     * @param string|null $searchByCode
     * @return PromoBlockCriteria
     */
    public function setSearchByCode(?string $searchByCode): PromoBlockCriteria
    {
        $this->searchByCode = $searchByCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    /**
     * @param string|null $searchByTitle
     * @return PromoBlockCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): PromoBlockCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }

}