<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 02.09.2020
 * Time: 23:55
 */

namespace Diamond\Repositories\Menu;


use Diamond\Domain\Menu\Contracts\MenuCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MenuCriteria extends AbstractCriteria implements MenuCriteriaInterface
{
    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var bool
     */
    protected $treeView = false;

    /**
     * @var string|null
     */
    protected $searchByUrl;
    /**
     * @var string|null
     */
    protected $searchByTitle;
    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @return bool
     */
    public function asTreeView(): bool
    {
        return $this->treeView;
    }

    /**
     * @param bool $asTreeView
     * @return MenuCriteria
     */
    public function setTreeView(bool $asTreeView): MenuCriteria
    {
        $this->treeView = $asTreeView;
        return $this;
    }

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getSearchByUrl(): ?string
    {
        return $this->searchByUrl;
    }

    /**
     * @param string|null $searchByUrl
     * @return MenuCriteria
     */
    public function setSearchByUrl(?string $searchByUrl): MenuCriteria
    {
        $this->searchByUrl = $searchByUrl;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    /**
     * @param string|null $searchByTitle
     * @return MenuCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): MenuCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return MenuCriteria
     */
    public function setSearchByName(?string $searchByName): MenuCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool|null $filterByActive
     * @return MenuCriteria
     */
    public function setFilterByActive(?bool $filterByActive): MenuCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }




}