<?php

namespace Diamond\Repositories\MailingRequestRecipient;

use Diamond\Domain\MailingRequestRecipient\Contracts\MailingRequestRecipientCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MailingRequestRecipientCriteria extends AbstractCriteria implements MailingRequestRecipientCriteriaInterface
{
    /**
     * @var int|null
     */
    private $filterByRequestId;

    public static function create()
    {
        return new self();
    }

    /**
     * @return int|null
     */
    public function getFilterByRequestId(): ?int
    {
        return $this->filterByRequestId;
    }

    /**
     * @param int|null $filterByRequestId
     * @return MailingRequestRecipientCriteria
     */
    public function setFilterByRequestId(?int $filterByRequestId): MailingRequestRecipientCriteriaInterface
    {
        $this->filterByRequestId = $filterByRequestId;
        return $this;
    }


}