<?php

namespace Diamond\Repositories\GuestBookItem;


use Diamond\Domain\GuestBookItem\Contracts\GuestBookItemCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class GuestBookItemCriteria extends AbstractCriteria implements GuestBookItemCriteriaInterface
{

    protected string|null $sortByDate = null;

    /**
     * @var string|null
     */
    protected $filterByDate;

    /**
     * @var int|null
     */
    protected $filterByBookId;

    /**
     * @var int|null
     */
    protected $filterByRank;

    /**
     * @var bool|null
     */
    protected $filterByPublished;


    /**
     * @var string|null
     */
    protected $searchByUserName;

    /**
     * @var string|null
     */
    protected $searchByUserEmail;

    /**
     * @var int|null
     */
    protected $filterByObjectId;

    public function getSortByDate(): ?string
    {
        return $this->sortByDate;
    }

    public function setSortByDate(?string $sortByDate): GuestBookItemCriteriaInterface
    {
        $this->sortByDate = $sortByDate;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByObjectId(): ?int
    {
        return $this->filterByObjectId;
    }

    /**
     * @param int|null $filterByObjectId
     * @return GuestBookItemCriteria
     */
    public function setFilterByObjectId(?int $filterByObjectId): GuestBookItemCriteriaInterface
    {
        $this->filterByObjectId = $filterByObjectId;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByDate(): ?string
    {
        return $this->filterByDate;
    }

    /**
     * @param string|null $filterByDate
     * @return GuestBookItemCriteria
     */
    public function setFilterByDate(?string $filterByDate): GuestBookItemCriteriaInterface
    {
        $this->filterByDate = $filterByDate;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSearchByUserName(): ?string
    {
        return $this->searchByUserName;
    }

    /**
     * @param string|null $searchByUserName
     * @return GuestBookItemCriteria
     */
    public function setSearchByUserName(?string $searchByUserName): GuestBookItemCriteriaInterface
    {
        $this->searchByUserName = $searchByUserName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByUserEmail(): ?string
    {
        return $this->searchByUserEmail;
    }

    /**
     * @param string|null $searchByUserEmail
     * @return GuestBookItemCriteria
     */
    public function setSearchByUserEmail(?string $searchByUserEmail): GuestBookItemCriteriaInterface
    {
        $this->searchByUserEmail = $searchByUserEmail;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getFilterByPublished(): ?bool
    {
        return $this->filterByPublished;
    }

    /**
     * @param bool|null $filterByPublished
     * @return GuestBookItemCriteria
     */
    public function setFilterByPublished(?bool $filterByPublished): GuestBookItemCriteriaInterface
    {
        $this->filterByPublished = $filterByPublished;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByBookId(): ?int
    {
        return $this->filterByBookId;
    }

    /**
     * @param int|null $filterByBookId
     * @return GuestBookItemCriteria
     */
    public function setFilterByBookId(?int $filterByBookId): GuestBookItemCriteriaInterface
    {
        $this->filterByBookId = $filterByBookId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByRank(): ?int
    {
        return $this->filterByRank;
    }

    /**
     * @param int|null $filterByRank
     * @return GuestBookItemCriteria
     */
    public function setFilterByRank(?int $filterByRank): GuestBookItemCriteriaInterface
    {
        $this->filterByRank = $filterByRank;
        return $this;
    }


    public static function create()
    {
        return new self;
    }
}