<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 14.06.2020
 * Time: 1:03
 */

namespace Diamond\Repositories\ErrorLog;

use Repo\Concrete\AbstractCriteria;

class ErrorLogCriteria extends AbstractCriteria
{
    /**
     * @var string|null
     */
    protected $filterByFileName;

    /**
     * @return ErrorLogCriteria
     */
    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByFileName(): ?string
    {
        return $this->filterByFileName;
    }

    /**
     * @param string|null $filterByFileName
     * @return ErrorLogCriteria
     */
    public function setFilterByFileName(?string $filterByFileName): ErrorLogCriteria
    {
        $this->filterByFileName = $filterByFileName;
        return $this;
    }



}