<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 01.09.2020
 * Time: 17:14
 */

namespace Diamond\Repositories\Content;


use Diamond\Domain\Content\ContentCollection;
use Diamond\Domain\Content\Contracts\ContentCriteriaInterface;
use Diamond\Infrastructure\Models\Content\Content;
use Diamond\Infrastructure\Models\Content\ContentQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class ContentRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new Content();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return ContentQuery::create();
    }

    /**
     * @param PaginationInterface|ContentCriteriaInterface $criteria
     * @param ModelCriteria|ContentQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dateTimeFrom = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDateCreate());

        if (!$date = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDateCreate())) {
            $dateTimeTo = null;
        } else {
            $dateTimeTo = \DateTime::createFromFormat('d.m.Y|', $criteria->getFilterByDateCreate())->modify('+1 day');
        }

        $dbCriteria
            ->_if($criteria->getFilterByTagIds() !== null)
            ->useContentTagRelQuery()
            ->filterByContentTagId($criteria->getFilterByTagIds())
            ->endUse()
            ->_endif()
            ->_if($criteria->getFilterByCategoryCode() !== null)
            ->useContentCategoryQuery()
            ->filterByCode($criteria->getFilterByCategoryCode())
            ->endUse()
            ->_endif()
            ->_if($criteria->getSearchByTitle() !== null)
            ->filterByTitle('%' . $criteria->getSearchByTitle() . '%', Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByCategoryId() !== null)
            ->filterByCategoryId($criteria->getFilterByCategoryId(), Criteria::LIKE)
            ->_endif()
            ->_if($criteria->getFilterByActive() !== null)
            ->filterByActive($criteria->getFilterByActive() === true ? 'Y' : 'N')
            ->_endif()
            ->_if($criteria->getFilterByDateCreate() !== null)
            ->filterByDatecreate($dateTimeFrom, Criteria::GREATER_EQUAL)
            ->filterByDatecreate($dateTimeTo, Criteria::LESS_THAN)
            ->_endif()
            ->_if($criteria->getSortByDateCreate() !== null)
            ->orderByDatecreate($criteria->getSortByDateCreate())
            ->_endif()
            ->_if($criteria->getSortByDate() !== null)
            ->orderByDate($criteria->getSortByDate())
            ->_endif()
        ;
    }

    protected function createCollection(): CollectionInterface
    {

        return new ContentCollection();
    }


}