<?php

namespace Diamond\Infrastructure\Models\User;

use Core\Contracts\UserInterface;
use Diamond\Domain\User\Contracts\UserEntityInterface;
use Diamond\Infrastructure\Models\User\Base\User as BaseUser;

/**
 * Skeleton subclass for representing a row from the '_users' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class User extends BaseUser implements UserEntityInterface, UserInterface
{
    private bool|null $cacheUserGroup = null;

    public function isRootRole(): bool
    {
        return $this->getUserGroup()->getGrpCode() === 'root';
    }

    public function getNameWithEmail(): string
    {
        return $this->name . ' [' . $this->email . ']';
    }

}
