<?php

namespace Diamond\Infrastructure\Models\User\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\User\User as ChildUser;
use Diamond\Infrastructure\Models\User\UserQuery as ChildUserQuery;
use Diamond\Infrastructure\Models\UserGroup\UserGroup;
use Diamond\Infrastructure\Models\User\Map\UserTableMap;
use PartScanner\Infrastructure\Models\Chat\Chat;
use PartScanner\Infrastructure\Models\ChatMessage\ChatMessage;
use PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRel;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_users' table.
 *
 *
 *
 * @method     ChildUserQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildUserQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildUserQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildUserQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method     ChildUserQuery orderByActivation($order = Criteria::ASC) Order by the activation column
 * @method     ChildUserQuery orderByGroupId($order = Criteria::ASC) Order by the group_id column
 * @method     ChildUserQuery orderByUsrDelete($order = Criteria::ASC) Order by the usr_delete column
 * @method     ChildUserQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 *
 * @method     ChildUserQuery groupById() Group by the id column
 * @method     ChildUserQuery groupByName() Group by the name column
 * @method     ChildUserQuery groupByEmail() Group by the email column
 * @method     ChildUserQuery groupByPassword() Group by the password column
 * @method     ChildUserQuery groupByActivation() Group by the activation column
 * @method     ChildUserQuery groupByGroupId() Group by the group_id column
 * @method     ChildUserQuery groupByUsrDelete() Group by the usr_delete column
 * @method     ChildUserQuery groupByCreatedAt() Group by the created_at column
 *
 * @method     ChildUserQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildUserQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildUserQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildUserQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildUserQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildUserQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildUserQuery leftJoinUserGroup($relationAlias = null) Adds a LEFT JOIN clause to the query using the UserGroup relation
 * @method     ChildUserQuery rightJoinUserGroup($relationAlias = null) Adds a RIGHT JOIN clause to the query using the UserGroup relation
 * @method     ChildUserQuery innerJoinUserGroup($relationAlias = null) Adds a INNER JOIN clause to the query using the UserGroup relation
 *
 * @method     ChildUserQuery joinWithUserGroup($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the UserGroup relation
 *
 * @method     ChildUserQuery leftJoinWithUserGroup() Adds a LEFT JOIN clause and with to the query using the UserGroup relation
 * @method     ChildUserQuery rightJoinWithUserGroup() Adds a RIGHT JOIN clause and with to the query using the UserGroup relation
 * @method     ChildUserQuery innerJoinWithUserGroup() Adds a INNER JOIN clause and with to the query using the UserGroup relation
 *
 * @method     ChildUserQuery leftJoinClientsUsersRel($relationAlias = null) Adds a LEFT JOIN clause to the query using the ClientsUsersRel relation
 * @method     ChildUserQuery rightJoinClientsUsersRel($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ClientsUsersRel relation
 * @method     ChildUserQuery innerJoinClientsUsersRel($relationAlias = null) Adds a INNER JOIN clause to the query using the ClientsUsersRel relation
 *
 * @method     ChildUserQuery joinWithClientsUsersRel($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ClientsUsersRel relation
 *
 * @method     ChildUserQuery leftJoinWithClientsUsersRel() Adds a LEFT JOIN clause and with to the query using the ClientsUsersRel relation
 * @method     ChildUserQuery rightJoinWithClientsUsersRel() Adds a RIGHT JOIN clause and with to the query using the ClientsUsersRel relation
 * @method     ChildUserQuery innerJoinWithClientsUsersRel() Adds a INNER JOIN clause and with to the query using the ClientsUsersRel relation
 *
 * @method     ChildUserQuery leftJoinChat($relationAlias = null) Adds a LEFT JOIN clause to the query using the Chat relation
 * @method     ChildUserQuery rightJoinChat($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Chat relation
 * @method     ChildUserQuery innerJoinChat($relationAlias = null) Adds a INNER JOIN clause to the query using the Chat relation
 *
 * @method     ChildUserQuery joinWithChat($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Chat relation
 *
 * @method     ChildUserQuery leftJoinWithChat() Adds a LEFT JOIN clause and with to the query using the Chat relation
 * @method     ChildUserQuery rightJoinWithChat() Adds a RIGHT JOIN clause and with to the query using the Chat relation
 * @method     ChildUserQuery innerJoinWithChat() Adds a INNER JOIN clause and with to the query using the Chat relation
 *
 * @method     ChildUserQuery leftJoinChatMessage($relationAlias = null) Adds a LEFT JOIN clause to the query using the ChatMessage relation
 * @method     ChildUserQuery rightJoinChatMessage($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ChatMessage relation
 * @method     ChildUserQuery innerJoinChatMessage($relationAlias = null) Adds a INNER JOIN clause to the query using the ChatMessage relation
 *
 * @method     ChildUserQuery joinWithChatMessage($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ChatMessage relation
 *
 * @method     ChildUserQuery leftJoinWithChatMessage() Adds a LEFT JOIN clause and with to the query using the ChatMessage relation
 * @method     ChildUserQuery rightJoinWithChatMessage() Adds a RIGHT JOIN clause and with to the query using the ChatMessage relation
 * @method     ChildUserQuery innerJoinWithChatMessage() Adds a INNER JOIN clause and with to the query using the ChatMessage relation
 *
 * @method     \Diamond\Infrastructure\Models\UserGroup\UserGroupQuery|\PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery|\PartScanner\Infrastructure\Models\Chat\ChatQuery|\PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildUser|null findOne(?ConnectionInterface $con = null) Return the first ChildUser matching the query
 * @method     ChildUser findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildUser matching the query, or a new ChildUser object populated from the query conditions when no match is found
 *
 * @method     ChildUser|null findOneById(int $id) Return the first ChildUser filtered by the id column
 * @method     ChildUser|null findOneByName(string $name) Return the first ChildUser filtered by the name column
 * @method     ChildUser|null findOneByEmail(string $email) Return the first ChildUser filtered by the email column
 * @method     ChildUser|null findOneByPassword(string $password) Return the first ChildUser filtered by the password column
 * @method     ChildUser|null findOneByActivation(string $activation) Return the first ChildUser filtered by the activation column
 * @method     ChildUser|null findOneByGroupId(int $group_id) Return the first ChildUser filtered by the group_id column
 * @method     ChildUser|null findOneByUsrDelete(int $usr_delete) Return the first ChildUser filtered by the usr_delete column
 * @method     ChildUser|null findOneByCreatedAt(string $created_at) Return the first ChildUser filtered by the created_at column *

 * @method     ChildUser requirePk($key, ?ConnectionInterface $con = null) Return the ChildUser by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOne(?ConnectionInterface $con = null) Return the first ChildUser matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildUser requireOneById(int $id) Return the first ChildUser filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByName(string $name) Return the first ChildUser filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByEmail(string $email) Return the first ChildUser filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByPassword(string $password) Return the first ChildUser filtered by the password column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByActivation(string $activation) Return the first ChildUser filtered by the activation column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByGroupId(int $group_id) Return the first ChildUser filtered by the group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByUsrDelete(int $usr_delete) Return the first ChildUser filtered by the usr_delete column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildUser requireOneByCreatedAt(string $created_at) Return the first ChildUser filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildUser[]|Collection find(?ConnectionInterface $con = null) Return ChildUser objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildUser> find(?ConnectionInterface $con = null) Return ChildUser objects based on current ModelCriteria
 * @method     ChildUser[]|Collection findById(int $id) Return ChildUser objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildUser> findById(int $id) Return ChildUser objects filtered by the id column
 * @method     ChildUser[]|Collection findByName(string $name) Return ChildUser objects filtered by the name column
 * @psalm-method Collection&\Traversable<ChildUser> findByName(string $name) Return ChildUser objects filtered by the name column
 * @method     ChildUser[]|Collection findByEmail(string $email) Return ChildUser objects filtered by the email column
 * @psalm-method Collection&\Traversable<ChildUser> findByEmail(string $email) Return ChildUser objects filtered by the email column
 * @method     ChildUser[]|Collection findByPassword(string $password) Return ChildUser objects filtered by the password column
 * @psalm-method Collection&\Traversable<ChildUser> findByPassword(string $password) Return ChildUser objects filtered by the password column
 * @method     ChildUser[]|Collection findByActivation(string $activation) Return ChildUser objects filtered by the activation column
 * @psalm-method Collection&\Traversable<ChildUser> findByActivation(string $activation) Return ChildUser objects filtered by the activation column
 * @method     ChildUser[]|Collection findByGroupId(int $group_id) Return ChildUser objects filtered by the group_id column
 * @psalm-method Collection&\Traversable<ChildUser> findByGroupId(int $group_id) Return ChildUser objects filtered by the group_id column
 * @method     ChildUser[]|Collection findByUsrDelete(int $usr_delete) Return ChildUser objects filtered by the usr_delete column
 * @psalm-method Collection&\Traversable<ChildUser> findByUsrDelete(int $usr_delete) Return ChildUser objects filtered by the usr_delete column
 * @method     ChildUser[]|Collection findByCreatedAt(string $created_at) Return ChildUser objects filtered by the created_at column
 * @psalm-method Collection&\Traversable<ChildUser> findByCreatedAt(string $created_at) Return ChildUser objects filtered by the created_at column
 * @method     ChildUser[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildUser> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class UserQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\User\Base\UserQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\User\\User', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildUserQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildUserQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildUserQuery) {
            return $criteria;
        }
        $query = new ChildUserQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildUser|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(UserTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = UserTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildUser A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `email`, `password`, `activation`, `group_id`, `usr_delete`, `created_at` FROM `_users` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildUser $obj */
            $obj = new ChildUser();
            $obj->hydrate($row);
            UserTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildUser|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(UserTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(UserTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(UserTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(UserTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * $query->filterByName(['foo', 'bar']); // WHERE name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $name The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByName($name = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_NAME, $name, $comparison);

        return $this;
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * $query->filterByEmail(['foo', 'bar']); // WHERE email IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $email The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByEmail($email = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_EMAIL, $email, $comparison);

        return $this;
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%', Criteria::LIKE); // WHERE password LIKE '%fooValue%'
     * $query->filterByPassword(['foo', 'bar']); // WHERE password IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $password The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPassword($password = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_PASSWORD, $password, $comparison);

        return $this;
    }

    /**
     * Filter the query on the activation column
     *
     * Example usage:
     * <code>
     * $query->filterByActivation('fooValue');   // WHERE activation = 'fooValue'
     * $query->filterByActivation('%fooValue%', Criteria::LIKE); // WHERE activation LIKE '%fooValue%'
     * $query->filterByActivation(['foo', 'bar']); // WHERE activation IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $activation The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByActivation($activation = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($activation)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_ACTIVATION, $activation, $comparison);

        return $this;
    }

    /**
     * Filter the query on the group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByGroupId(1234); // WHERE group_id = 1234
     * $query->filterByGroupId(array(12, 34)); // WHERE group_id IN (12, 34)
     * $query->filterByGroupId(array('min' => 12)); // WHERE group_id > 12
     * </code>
     *
     * @see       filterByUserGroup()
     *
     * @param mixed $groupId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByGroupId($groupId = null, ?string $comparison = null)
    {
        if (is_array($groupId)) {
            $useMinMax = false;
            if (isset($groupId['min'])) {
                $this->addUsingAlias(UserTableMap::COL_GROUP_ID, $groupId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($groupId['max'])) {
                $this->addUsingAlias(UserTableMap::COL_GROUP_ID, $groupId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_GROUP_ID, $groupId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the usr_delete column
     *
     * Example usage:
     * <code>
     * $query->filterByUsrDelete(1234); // WHERE usr_delete = 1234
     * $query->filterByUsrDelete(array(12, 34)); // WHERE usr_delete IN (12, 34)
     * $query->filterByUsrDelete(array('min' => 12)); // WHERE usr_delete > 12
     * </code>
     *
     * @param mixed $usrDelete The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUsrDelete($usrDelete = null, ?string $comparison = null)
    {
        if (is_array($usrDelete)) {
            $useMinMax = false;
            if (isset($usrDelete['min'])) {
                $this->addUsingAlias(UserTableMap::COL_USR_DELETE, $usrDelete['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($usrDelete['max'])) {
                $this->addUsingAlias(UserTableMap::COL_USR_DELETE, $usrDelete['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_USR_DELETE, $usrDelete, $comparison);

        return $this;
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, ?string $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(UserTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(UserTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(UserTableMap::COL_CREATED_AT, $createdAt, $comparison);

        return $this;
    }

    /**
     * Filter the query by a related \Diamond\Infrastructure\Models\UserGroup\UserGroup object
     *
     * @param \Diamond\Infrastructure\Models\UserGroup\UserGroup|ObjectCollection $userGroup The related object(s) to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUserGroup($userGroup, ?string $comparison = null)
    {
        if ($userGroup instanceof \Diamond\Infrastructure\Models\UserGroup\UserGroup) {
            return $this
                ->addUsingAlias(UserTableMap::COL_GROUP_ID, $userGroup->getId(), $comparison);
        } elseif ($userGroup instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            $this
                ->addUsingAlias(UserTableMap::COL_GROUP_ID, $userGroup->toKeyValue('PrimaryKey', 'Id'), $comparison);

            return $this;
        } else {
            throw new PropelException('filterByUserGroup() only accepts arguments of type \Diamond\Infrastructure\Models\UserGroup\UserGroup or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the UserGroup relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinUserGroup(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('UserGroup');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'UserGroup');
        }

        return $this;
    }

    /**
     * Use the UserGroup relation UserGroup object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Diamond\Infrastructure\Models\UserGroup\UserGroupQuery A secondary query class using the current class as primary query
     */
    public function useUserGroupQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinUserGroup($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'UserGroup', '\Diamond\Infrastructure\Models\UserGroup\UserGroupQuery');
    }

    /**
     * Use the UserGroup relation UserGroup object
     *
     * @param callable(\Diamond\Infrastructure\Models\UserGroup\UserGroupQuery):\Diamond\Infrastructure\Models\UserGroup\UserGroupQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withUserGroupQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useUserGroupQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to UserGroup table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \Diamond\Infrastructure\Models\UserGroup\UserGroupQuery The inner query object of the EXISTS statement
     */
    public function useUserGroupExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('UserGroup', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to UserGroup table for a NOT EXISTS query.
     *
     * @see useUserGroupExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \Diamond\Infrastructure\Models\UserGroup\UserGroupQuery The inner query object of the NOT EXISTS statement
     */
    public function useUserGroupNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('UserGroup', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRel object
     *
     * @param \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRel|ObjectCollection $clientsUsersRel the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByClientsUsersRel($clientsUsersRel, ?string $comparison = null)
    {
        if ($clientsUsersRel instanceof \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRel) {
            $this
                ->addUsingAlias(UserTableMap::COL_ID, $clientsUsersRel->getUserId(), $comparison);

            return $this;
        } elseif ($clientsUsersRel instanceof ObjectCollection) {
            $this
                ->useClientsUsersRelQuery()
                ->filterByPrimaryKeys($clientsUsersRel->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByClientsUsersRel() only accepts arguments of type \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRel or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ClientsUsersRel relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinClientsUsersRel(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ClientsUsersRel');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ClientsUsersRel');
        }

        return $this;
    }

    /**
     * Use the ClientsUsersRel relation ClientsUsersRel object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery A secondary query class using the current class as primary query
     */
    public function useClientsUsersRelQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinClientsUsersRel($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ClientsUsersRel', '\PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery');
    }

    /**
     * Use the ClientsUsersRel relation ClientsUsersRel object
     *
     * @param callable(\PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery):\PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withClientsUsersRelQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useClientsUsersRelQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to ClientsUsersRel table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery The inner query object of the EXISTS statement
     */
    public function useClientsUsersRelExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ClientsUsersRel', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to ClientsUsersRel table for a NOT EXISTS query.
     *
     * @see useClientsUsersRelExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \PartScanner\Infrastructure\Models\ClientsUsersRel\ClientsUsersRelQuery The inner query object of the NOT EXISTS statement
     */
    public function useClientsUsersRelNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ClientsUsersRel', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\Chat\Chat object
     *
     * @param \PartScanner\Infrastructure\Models\Chat\Chat|ObjectCollection $chat the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByChat($chat, ?string $comparison = null)
    {
        if ($chat instanceof \PartScanner\Infrastructure\Models\Chat\Chat) {
            $this
                ->addUsingAlias(UserTableMap::COL_ID, $chat->getUserId(), $comparison);

            return $this;
        } elseif ($chat instanceof ObjectCollection) {
            $this
                ->useChatQuery()
                ->filterByPrimaryKeys($chat->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByChat() only accepts arguments of type \PartScanner\Infrastructure\Models\Chat\Chat or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Chat relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinChat(?string $relationAlias = null, ?string $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Chat');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Chat');
        }

        return $this;
    }

    /**
     * Use the Chat relation Chat object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\Chat\ChatQuery A secondary query class using the current class as primary query
     */
    public function useChatQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinChat($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Chat', '\PartScanner\Infrastructure\Models\Chat\ChatQuery');
    }

    /**
     * Use the Chat relation Chat object
     *
     * @param callable(\PartScanner\Infrastructure\Models\Chat\ChatQuery):\PartScanner\Infrastructure\Models\Chat\ChatQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withChatQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::INNER_JOIN
    ) {
        $relatedQuery = $this->useChatQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to Chat table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \PartScanner\Infrastructure\Models\Chat\ChatQuery The inner query object of the EXISTS statement
     */
    public function useChatExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('Chat', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to Chat table for a NOT EXISTS query.
     *
     * @see useChatExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \PartScanner\Infrastructure\Models\Chat\ChatQuery The inner query object of the NOT EXISTS statement
     */
    public function useChatNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('Chat', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related \PartScanner\Infrastructure\Models\ChatMessage\ChatMessage object
     *
     * @param \PartScanner\Infrastructure\Models\ChatMessage\ChatMessage|ObjectCollection $chatMessage the related object to use as filter
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByChatMessage($chatMessage, ?string $comparison = null)
    {
        if ($chatMessage instanceof \PartScanner\Infrastructure\Models\ChatMessage\ChatMessage) {
            $this
                ->addUsingAlias(UserTableMap::COL_ID, $chatMessage->getUserId(), $comparison);

            return $this;
        } elseif ($chatMessage instanceof ObjectCollection) {
            $this
                ->useChatMessageQuery()
                ->filterByPrimaryKeys($chatMessage->getPrimaryKeys())
                ->endUse();

            return $this;
        } else {
            throw new PropelException('filterByChatMessage() only accepts arguments of type \PartScanner\Infrastructure\Models\ChatMessage\ChatMessage or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ChatMessage relation
     *
     * @param string|null $relationAlias Optional alias for the relation
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this The current query, for fluid interface
     */
    public function joinChatMessage(?string $relationAlias = null, ?string $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ChatMessage');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ChatMessage');
        }

        return $this;
    }

    /**
     * Use the ChatMessage relation ChatMessage object
     *
     * @see useQuery()
     *
     * @param string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery A secondary query class using the current class as primary query
     */
    public function useChatMessageQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinChatMessage($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ChatMessage', '\PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery');
    }

    /**
     * Use the ChatMessage relation ChatMessage object
     *
     * @param callable(\PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery):\PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery $callable A function working on the related query
     *
     * @param string|null $relationAlias optional alias for the relation
     *
     * @param string|null $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this
     */
    public function withChatMessageQuery(
        callable $callable,
        string $relationAlias = null,
        ?string $joinType = Criteria::LEFT_JOIN
    ) {
        $relatedQuery = $this->useChatMessageQuery(
            $relationAlias,
            $joinType
        );
        $callable($relatedQuery);
        $relatedQuery->endUse();

        return $this;
    }
    /**
     * Use the relation to ChatMessage table for an EXISTS query.
     *
     * @see \Propel\Runtime\ActiveQuery\ModelCriteria::useExistsQuery()
     *
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string $typeOfExists Either ExistsCriterion::TYPE_EXISTS or ExistsCriterion::TYPE_NOT_EXISTS
     *
     * @return \PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery The inner query object of the EXISTS statement
     */
    public function useChatMessageExistsQuery($modelAlias = null, $queryClass = null, $typeOfExists = 'EXISTS')
    {
        return $this->useExistsQuery('ChatMessage', $modelAlias, $queryClass, $typeOfExists);
    }

    /**
     * Use the relation to ChatMessage table for a NOT EXISTS query.
     *
     * @see useChatMessageExistsQuery()
     *
     * @param string|null $modelAlias sets an alias for the nested query
     * @param string|null $queryClass Allows to use a custom query class for the exists query, like ExtendedBookQuery::class
     *
     * @return \PartScanner\Infrastructure\Models\ChatMessage\ChatMessageQuery The inner query object of the NOT EXISTS statement
     */
    public function useChatMessageNotExistsQuery($modelAlias = null, $queryClass = null)
    {
        return $this->useExistsQuery('ChatMessage', $modelAlias, $queryClass, 'NOT EXISTS');
    }
    /**
     * Filter the query by a related Client object
     * using the partscanner_clients_users_rel table as cross reference
     *
     * @param Client $client the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByClient($client, string $comparison = Criteria::EQUAL)
    {
        $this
            ->useClientsUsersRelQuery()
            ->filterByClient($client, $comparison)
            ->endUse();

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildUser $user Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($user = null)
    {
        if ($user) {
            $this->addUsingAlias(UserTableMap::COL_ID, $user->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _users table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(UserTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            UserTableMap::clearInstancePool();
            UserTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(UserTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(UserTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            UserTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            UserTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
