<?php

namespace Diamond\Infrastructure\Models\StatRule\Map;

use Diamond\Infrastructure\Models\StatRule\StatRule;
use Diamond\Infrastructure\Models\StatRule\StatRuleQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_stat_rules' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class StatRuleTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.StatRule.Map.StatRuleTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_stat_rules';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\StatRule\\StatRule';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.StatRule.StatRule';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 12;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 12;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_stat_rules.id';

    /**
     * the column name for the name field
     */
    public const COL_NAME = '_stat_rules.name';

    /**
     * the column name for the client_type field
     */
    public const COL_CLIENT_TYPE = '_stat_rules.client_type';

    /**
     * the column name for the uri_mask field
     */
    public const COL_URI_MASK = '_stat_rules.uri_mask';

    /**
     * the column name for the ip_mask field
     */
    public const COL_IP_MASK = '_stat_rules.ip_mask';

    /**
     * the column name for the agent_mask field
     */
    public const COL_AGENT_MASK = '_stat_rules.agent_mask';

    /**
     * the column name for the host_mask field
     */
    public const COL_HOST_MASK = '_stat_rules.host_mask';

    /**
     * the column name for the rule field
     */
    public const COL_RULE = '_stat_rules.rule';

    /**
     * the column name for the period field
     */
    public const COL_PERIOD = '_stat_rules.period';

    /**
     * the column name for the ban_rate field
     */
    public const COL_BAN_RATE = '_stat_rules.ban_rate';

    /**
     * the column name for the ban_uri field
     */
    public const COL_BAN_URI = '_stat_rules.ban_uri';

    /**
     * the column name for the ban_period field
     */
    public const COL_BAN_PERIOD = '_stat_rules.ban_period';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Name', 'ClientType', 'UriMask', 'IpMask', 'AgentMask', 'HostMask', 'Rule', 'Period', 'BanRate', 'BanUri', 'BanPeriod', ],
        self::TYPE_CAMELNAME     => ['id', 'name', 'clientType', 'uriMask', 'ipMask', 'agentMask', 'hostMask', 'rule', 'period', 'banRate', 'banUri', 'banPeriod', ],
        self::TYPE_COLNAME       => [StatRuleTableMap::COL_ID, StatRuleTableMap::COL_NAME, StatRuleTableMap::COL_CLIENT_TYPE, StatRuleTableMap::COL_URI_MASK, StatRuleTableMap::COL_IP_MASK, StatRuleTableMap::COL_AGENT_MASK, StatRuleTableMap::COL_HOST_MASK, StatRuleTableMap::COL_RULE, StatRuleTableMap::COL_PERIOD, StatRuleTableMap::COL_BAN_RATE, StatRuleTableMap::COL_BAN_URI, StatRuleTableMap::COL_BAN_PERIOD, ],
        self::TYPE_FIELDNAME     => ['id', 'name', 'client_type', 'uri_mask', 'ip_mask', 'agent_mask', 'host_mask', 'rule', 'period', 'ban_rate', 'ban_uri', 'ban_period', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Name' => 1, 'ClientType' => 2, 'UriMask' => 3, 'IpMask' => 4, 'AgentMask' => 5, 'HostMask' => 6, 'Rule' => 7, 'Period' => 8, 'BanRate' => 9, 'BanUri' => 10, 'BanPeriod' => 11, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'name' => 1, 'clientType' => 2, 'uriMask' => 3, 'ipMask' => 4, 'agentMask' => 5, 'hostMask' => 6, 'rule' => 7, 'period' => 8, 'banRate' => 9, 'banUri' => 10, 'banPeriod' => 11, ],
        self::TYPE_COLNAME       => [StatRuleTableMap::COL_ID => 0, StatRuleTableMap::COL_NAME => 1, StatRuleTableMap::COL_CLIENT_TYPE => 2, StatRuleTableMap::COL_URI_MASK => 3, StatRuleTableMap::COL_IP_MASK => 4, StatRuleTableMap::COL_AGENT_MASK => 5, StatRuleTableMap::COL_HOST_MASK => 6, StatRuleTableMap::COL_RULE => 7, StatRuleTableMap::COL_PERIOD => 8, StatRuleTableMap::COL_BAN_RATE => 9, StatRuleTableMap::COL_BAN_URI => 10, StatRuleTableMap::COL_BAN_PERIOD => 11, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'name' => 1, 'client_type' => 2, 'uri_mask' => 3, 'ip_mask' => 4, 'agent_mask' => 5, 'host_mask' => 6, 'rule' => 7, 'period' => 8, 'ban_rate' => 9, 'ban_uri' => 10, 'ban_period' => 11, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'StatRule.Id' => 'ID',
        'id' => 'ID',
        'statRule.id' => 'ID',
        'StatRuleTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_stat_rules.id' => 'ID',
        'Name' => 'NAME',
        'StatRule.Name' => 'NAME',
        'name' => 'NAME',
        'statRule.name' => 'NAME',
        'StatRuleTableMap::COL_NAME' => 'NAME',
        'COL_NAME' => 'NAME',
        '_stat_rules.name' => 'NAME',
        'ClientType' => 'CLIENT_TYPE',
        'StatRule.ClientType' => 'CLIENT_TYPE',
        'clientType' => 'CLIENT_TYPE',
        'statRule.clientType' => 'CLIENT_TYPE',
        'StatRuleTableMap::COL_CLIENT_TYPE' => 'CLIENT_TYPE',
        'COL_CLIENT_TYPE' => 'CLIENT_TYPE',
        'client_type' => 'CLIENT_TYPE',
        '_stat_rules.client_type' => 'CLIENT_TYPE',
        'UriMask' => 'URI_MASK',
        'StatRule.UriMask' => 'URI_MASK',
        'uriMask' => 'URI_MASK',
        'statRule.uriMask' => 'URI_MASK',
        'StatRuleTableMap::COL_URI_MASK' => 'URI_MASK',
        'COL_URI_MASK' => 'URI_MASK',
        'uri_mask' => 'URI_MASK',
        '_stat_rules.uri_mask' => 'URI_MASK',
        'IpMask' => 'IP_MASK',
        'StatRule.IpMask' => 'IP_MASK',
        'ipMask' => 'IP_MASK',
        'statRule.ipMask' => 'IP_MASK',
        'StatRuleTableMap::COL_IP_MASK' => 'IP_MASK',
        'COL_IP_MASK' => 'IP_MASK',
        'ip_mask' => 'IP_MASK',
        '_stat_rules.ip_mask' => 'IP_MASK',
        'AgentMask' => 'AGENT_MASK',
        'StatRule.AgentMask' => 'AGENT_MASK',
        'agentMask' => 'AGENT_MASK',
        'statRule.agentMask' => 'AGENT_MASK',
        'StatRuleTableMap::COL_AGENT_MASK' => 'AGENT_MASK',
        'COL_AGENT_MASK' => 'AGENT_MASK',
        'agent_mask' => 'AGENT_MASK',
        '_stat_rules.agent_mask' => 'AGENT_MASK',
        'HostMask' => 'HOST_MASK',
        'StatRule.HostMask' => 'HOST_MASK',
        'hostMask' => 'HOST_MASK',
        'statRule.hostMask' => 'HOST_MASK',
        'StatRuleTableMap::COL_HOST_MASK' => 'HOST_MASK',
        'COL_HOST_MASK' => 'HOST_MASK',
        'host_mask' => 'HOST_MASK',
        '_stat_rules.host_mask' => 'HOST_MASK',
        'Rule' => 'RULE',
        'StatRule.Rule' => 'RULE',
        'rule' => 'RULE',
        'statRule.rule' => 'RULE',
        'StatRuleTableMap::COL_RULE' => 'RULE',
        'COL_RULE' => 'RULE',
        '_stat_rules.rule' => 'RULE',
        'Period' => 'PERIOD',
        'StatRule.Period' => 'PERIOD',
        'period' => 'PERIOD',
        'statRule.period' => 'PERIOD',
        'StatRuleTableMap::COL_PERIOD' => 'PERIOD',
        'COL_PERIOD' => 'PERIOD',
        '_stat_rules.period' => 'PERIOD',
        'BanRate' => 'BAN_RATE',
        'StatRule.BanRate' => 'BAN_RATE',
        'banRate' => 'BAN_RATE',
        'statRule.banRate' => 'BAN_RATE',
        'StatRuleTableMap::COL_BAN_RATE' => 'BAN_RATE',
        'COL_BAN_RATE' => 'BAN_RATE',
        'ban_rate' => 'BAN_RATE',
        '_stat_rules.ban_rate' => 'BAN_RATE',
        'BanUri' => 'BAN_URI',
        'StatRule.BanUri' => 'BAN_URI',
        'banUri' => 'BAN_URI',
        'statRule.banUri' => 'BAN_URI',
        'StatRuleTableMap::COL_BAN_URI' => 'BAN_URI',
        'COL_BAN_URI' => 'BAN_URI',
        'ban_uri' => 'BAN_URI',
        '_stat_rules.ban_uri' => 'BAN_URI',
        'BanPeriod' => 'BAN_PERIOD',
        'StatRule.BanPeriod' => 'BAN_PERIOD',
        'banPeriod' => 'BAN_PERIOD',
        'statRule.banPeriod' => 'BAN_PERIOD',
        'StatRuleTableMap::COL_BAN_PERIOD' => 'BAN_PERIOD',
        'COL_BAN_PERIOD' => 'BAN_PERIOD',
        'ban_period' => 'BAN_PERIOD',
        '_stat_rules.ban_period' => 'BAN_PERIOD',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_stat_rules');
        $this->setPhpName('StatRule');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\StatRule\\StatRule');
        $this->setPackage('Diamond.Infrastructure.Models.StatRule');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', true, 255, null);
        $this->addColumn('client_type', 'ClientType', 'VARCHAR', true, 20, '%');
        $this->addColumn('uri_mask', 'UriMask', 'VARCHAR', true, 255, '%');
        $this->addColumn('ip_mask', 'IpMask', 'VARCHAR', true, 255, '%');
        $this->addColumn('agent_mask', 'AgentMask', 'VARCHAR', true, 255, '%');
        $this->addColumn('host_mask', 'HostMask', 'VARCHAR', true, 255, '%');
        $this->addColumn('rule', 'Rule', 'CHAR', true, null, 'DENY');
        $this->addColumn('period', 'Period', 'INTEGER', false, null, null);
        $this->addColumn('ban_rate', 'BanRate', 'INTEGER', false, null, null);
        $this->addColumn('ban_uri', 'BanUri', 'VARCHAR', false, 255, null);
        $this->addColumn('ban_period', 'BanPeriod', 'INTEGER', false, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? StatRuleTableMap::CLASS_DEFAULT : StatRuleTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (StatRule object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = StatRuleTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = StatRuleTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + StatRuleTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = StatRuleTableMap::OM_CLASS;
            /** @var StatRule $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            StatRuleTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = StatRuleTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = StatRuleTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var StatRule $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                StatRuleTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(StatRuleTableMap::COL_ID);
            $criteria->addSelectColumn(StatRuleTableMap::COL_NAME);
            $criteria->addSelectColumn(StatRuleTableMap::COL_CLIENT_TYPE);
            $criteria->addSelectColumn(StatRuleTableMap::COL_URI_MASK);
            $criteria->addSelectColumn(StatRuleTableMap::COL_IP_MASK);
            $criteria->addSelectColumn(StatRuleTableMap::COL_AGENT_MASK);
            $criteria->addSelectColumn(StatRuleTableMap::COL_HOST_MASK);
            $criteria->addSelectColumn(StatRuleTableMap::COL_RULE);
            $criteria->addSelectColumn(StatRuleTableMap::COL_PERIOD);
            $criteria->addSelectColumn(StatRuleTableMap::COL_BAN_RATE);
            $criteria->addSelectColumn(StatRuleTableMap::COL_BAN_URI);
            $criteria->addSelectColumn(StatRuleTableMap::COL_BAN_PERIOD);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.client_type');
            $criteria->addSelectColumn($alias . '.uri_mask');
            $criteria->addSelectColumn($alias . '.ip_mask');
            $criteria->addSelectColumn($alias . '.agent_mask');
            $criteria->addSelectColumn($alias . '.host_mask');
            $criteria->addSelectColumn($alias . '.rule');
            $criteria->addSelectColumn($alias . '.period');
            $criteria->addSelectColumn($alias . '.ban_rate');
            $criteria->addSelectColumn($alias . '.ban_uri');
            $criteria->addSelectColumn($alias . '.ban_period');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(StatRuleTableMap::COL_ID);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_NAME);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_CLIENT_TYPE);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_URI_MASK);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_IP_MASK);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_AGENT_MASK);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_HOST_MASK);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_RULE);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_PERIOD);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_BAN_RATE);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_BAN_URI);
            $criteria->removeSelectColumn(StatRuleTableMap::COL_BAN_PERIOD);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.name');
            $criteria->removeSelectColumn($alias . '.client_type');
            $criteria->removeSelectColumn($alias . '.uri_mask');
            $criteria->removeSelectColumn($alias . '.ip_mask');
            $criteria->removeSelectColumn($alias . '.agent_mask');
            $criteria->removeSelectColumn($alias . '.host_mask');
            $criteria->removeSelectColumn($alias . '.rule');
            $criteria->removeSelectColumn($alias . '.period');
            $criteria->removeSelectColumn($alias . '.ban_rate');
            $criteria->removeSelectColumn($alias . '.ban_uri');
            $criteria->removeSelectColumn($alias . '.ban_period');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(StatRuleTableMap::DATABASE_NAME)->getTable(StatRuleTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a StatRule or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or StatRule object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\StatRule\StatRule) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(StatRuleTableMap::DATABASE_NAME);
            $criteria->add(StatRuleTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = StatRuleQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            StatRuleTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                StatRuleTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _stat_rules table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return StatRuleQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a StatRule or Criteria object.
     *
     * @param mixed $criteria Criteria or StatRule object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatRuleTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from StatRule object
        }

        if ($criteria->containsKey(StatRuleTableMap::COL_ID) && $criteria->keyContainsValue(StatRuleTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.StatRuleTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = StatRuleQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
