<?php

namespace Diamond\Infrastructure\Models\StatBan\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\StatBan\StatBan as ChildStatBan;
use Diamond\Infrastructure\Models\StatBan\StatBanQuery as ChildStatBanQuery;
use Diamond\Infrastructure\Models\StatBan\Map\StatBanTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_stat_bans' table.
 *
 *
 *
 * @method     ChildStatBanQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildStatBanQuery orderByIpMask($order = Criteria::ASC) Order by the ip_mask column
 * @method     ChildStatBanQuery orderByPeriod($order = Criteria::ASC) Order by the period column
 * @method     ChildStatBanQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildStatBanQuery orderByRule($order = Criteria::ASC) Order by the rule column
 * @method     ChildStatBanQuery orderByUriMask($order = Criteria::ASC) Order by the uri_mask column
 * @method     ChildStatBanQuery orderByAgentMask($order = Criteria::ASC) Order by the agent_mask column
 * @method     ChildStatBanQuery orderByHostName($order = Criteria::ASC) Order by the host_name column
 *
 * @method     ChildStatBanQuery groupById() Group by the id column
 * @method     ChildStatBanQuery groupByIpMask() Group by the ip_mask column
 * @method     ChildStatBanQuery groupByPeriod() Group by the period column
 * @method     ChildStatBanQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildStatBanQuery groupByRule() Group by the rule column
 * @method     ChildStatBanQuery groupByUriMask() Group by the uri_mask column
 * @method     ChildStatBanQuery groupByAgentMask() Group by the agent_mask column
 * @method     ChildStatBanQuery groupByHostName() Group by the host_name column
 *
 * @method     ChildStatBanQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStatBanQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStatBanQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStatBanQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStatBanQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStatBanQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStatBan|null findOne(?ConnectionInterface $con = null) Return the first ChildStatBan matching the query
 * @method     ChildStatBan findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildStatBan matching the query, or a new ChildStatBan object populated from the query conditions when no match is found
 *
 * @method     ChildStatBan|null findOneById(int $id) Return the first ChildStatBan filtered by the id column
 * @method     ChildStatBan|null findOneByIpMask(string $ip_mask) Return the first ChildStatBan filtered by the ip_mask column
 * @method     ChildStatBan|null findOneByPeriod(int $period) Return the first ChildStatBan filtered by the period column
 * @method     ChildStatBan|null findOneByCreatedAt(string $created_at) Return the first ChildStatBan filtered by the created_at column
 * @method     ChildStatBan|null findOneByRule(string $rule) Return the first ChildStatBan filtered by the rule column
 * @method     ChildStatBan|null findOneByUriMask(string $uri_mask) Return the first ChildStatBan filtered by the uri_mask column
 * @method     ChildStatBan|null findOneByAgentMask(string $agent_mask) Return the first ChildStatBan filtered by the agent_mask column
 * @method     ChildStatBan|null findOneByHostName(string $host_name) Return the first ChildStatBan filtered by the host_name column *

 * @method     ChildStatBan requirePk($key, ?ConnectionInterface $con = null) Return the ChildStatBan by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOne(?ConnectionInterface $con = null) Return the first ChildStatBan matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStatBan requireOneById(int $id) Return the first ChildStatBan filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByIpMask(string $ip_mask) Return the first ChildStatBan filtered by the ip_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByPeriod(int $period) Return the first ChildStatBan filtered by the period column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByCreatedAt(string $created_at) Return the first ChildStatBan filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByRule(string $rule) Return the first ChildStatBan filtered by the rule column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByUriMask(string $uri_mask) Return the first ChildStatBan filtered by the uri_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByAgentMask(string $agent_mask) Return the first ChildStatBan filtered by the agent_mask column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStatBan requireOneByHostName(string $host_name) Return the first ChildStatBan filtered by the host_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStatBan[]|Collection find(?ConnectionInterface $con = null) Return ChildStatBan objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildStatBan> find(?ConnectionInterface $con = null) Return ChildStatBan objects based on current ModelCriteria
 * @method     ChildStatBan[]|Collection findById(int $id) Return ChildStatBan objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildStatBan> findById(int $id) Return ChildStatBan objects filtered by the id column
 * @method     ChildStatBan[]|Collection findByIpMask(string $ip_mask) Return ChildStatBan objects filtered by the ip_mask column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByIpMask(string $ip_mask) Return ChildStatBan objects filtered by the ip_mask column
 * @method     ChildStatBan[]|Collection findByPeriod(int $period) Return ChildStatBan objects filtered by the period column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByPeriod(int $period) Return ChildStatBan objects filtered by the period column
 * @method     ChildStatBan[]|Collection findByCreatedAt(string $created_at) Return ChildStatBan objects filtered by the created_at column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByCreatedAt(string $created_at) Return ChildStatBan objects filtered by the created_at column
 * @method     ChildStatBan[]|Collection findByRule(string $rule) Return ChildStatBan objects filtered by the rule column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByRule(string $rule) Return ChildStatBan objects filtered by the rule column
 * @method     ChildStatBan[]|Collection findByUriMask(string $uri_mask) Return ChildStatBan objects filtered by the uri_mask column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByUriMask(string $uri_mask) Return ChildStatBan objects filtered by the uri_mask column
 * @method     ChildStatBan[]|Collection findByAgentMask(string $agent_mask) Return ChildStatBan objects filtered by the agent_mask column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByAgentMask(string $agent_mask) Return ChildStatBan objects filtered by the agent_mask column
 * @method     ChildStatBan[]|Collection findByHostName(string $host_name) Return ChildStatBan objects filtered by the host_name column
 * @psalm-method Collection&\Traversable<ChildStatBan> findByHostName(string $host_name) Return ChildStatBan objects filtered by the host_name column
 * @method     ChildStatBan[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildStatBan> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StatBanQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\StatBan\Base\StatBanQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\StatBan\\StatBan', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStatBanQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStatBanQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildStatBanQuery) {
            return $criteria;
        }
        $query = new ChildStatBanQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildStatBan|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StatBanTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StatBanTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStatBan A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `ip_mask`, `period`, `created_at`, `rule`, `uri_mask`, `agent_mask`, `host_name` FROM `_stat_bans` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildStatBan $obj */
            $obj = new ChildStatBan();
            $obj->hydrate($row);
            StatBanTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildStatBan|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(StatBanTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(StatBanTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(StatBanTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(StatBanTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ip_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByIpMask('fooValue');   // WHERE ip_mask = 'fooValue'
     * $query->filterByIpMask('%fooValue%', Criteria::LIKE); // WHERE ip_mask LIKE '%fooValue%'
     * $query->filterByIpMask(['foo', 'bar']); // WHERE ip_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $ipMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByIpMask($ipMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ipMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_IP_MASK, $ipMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the period column
     *
     * Example usage:
     * <code>
     * $query->filterByPeriod(1234); // WHERE period = 1234
     * $query->filterByPeriod(array(12, 34)); // WHERE period IN (12, 34)
     * $query->filterByPeriod(array('min' => 12)); // WHERE period > 12
     * </code>
     *
     * @param mixed $period The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPeriod($period = null, ?string $comparison = null)
    {
        if (is_array($period)) {
            $useMinMax = false;
            if (isset($period['min'])) {
                $this->addUsingAlias(StatBanTableMap::COL_PERIOD, $period['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($period['max'])) {
                $this->addUsingAlias(StatBanTableMap::COL_PERIOD, $period['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_PERIOD, $period, $comparison);

        return $this;
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, ?string $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(StatBanTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(StatBanTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_CREATED_AT, $createdAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rule column
     *
     * Example usage:
     * <code>
     * $query->filterByRule('fooValue');   // WHERE rule = 'fooValue'
     * $query->filterByRule('%fooValue%', Criteria::LIKE); // WHERE rule LIKE '%fooValue%'
     * $query->filterByRule(['foo', 'bar']); // WHERE rule IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $rule The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRule($rule = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rule)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_RULE, $rule, $comparison);

        return $this;
    }

    /**
     * Filter the query on the uri_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByUriMask('fooValue');   // WHERE uri_mask = 'fooValue'
     * $query->filterByUriMask('%fooValue%', Criteria::LIKE); // WHERE uri_mask LIKE '%fooValue%'
     * $query->filterByUriMask(['foo', 'bar']); // WHERE uri_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $uriMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUriMask($uriMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($uriMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_URI_MASK, $uriMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the agent_mask column
     *
     * Example usage:
     * <code>
     * $query->filterByAgentMask('fooValue');   // WHERE agent_mask = 'fooValue'
     * $query->filterByAgentMask('%fooValue%', Criteria::LIKE); // WHERE agent_mask LIKE '%fooValue%'
     * $query->filterByAgentMask(['foo', 'bar']); // WHERE agent_mask IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $agentMask The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByAgentMask($agentMask = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($agentMask)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_AGENT_MASK, $agentMask, $comparison);

        return $this;
    }

    /**
     * Filter the query on the host_name column
     *
     * Example usage:
     * <code>
     * $query->filterByHostName('fooValue');   // WHERE host_name = 'fooValue'
     * $query->filterByHostName('%fooValue%', Criteria::LIKE); // WHERE host_name LIKE '%fooValue%'
     * $query->filterByHostName(['foo', 'bar']); // WHERE host_name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $hostName The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByHostName($hostName = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($hostName)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(StatBanTableMap::COL_HOST_NAME, $hostName, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildStatBan $statBan Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($statBan = null)
    {
        if ($statBan) {
            $this->addUsingAlias(StatBanTableMap::COL_ID, $statBan->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _stat_bans table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatBanTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StatBanTableMap::clearInstancePool();
            StatBanTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatBanTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StatBanTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StatBanTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StatBanTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
