<?php

namespace Diamond\Infrastructure\Models\Content\Base;

use \DateTime;
use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Content\Content as ChildContent;
use Diamond\Infrastructure\Models\Content\ContentArchive as ChildContentArchive;
use Diamond\Infrastructure\Models\Content\ContentArchiveQuery as ChildContentArchiveQuery;
use Diamond\Infrastructure\Models\Content\ContentQuery as ChildContentQuery;
use Diamond\Infrastructure\Models\ContentCategory\ContentCategory;
use Diamond\Infrastructure\Models\ContentCategory\ContentCategoryQuery;
use Diamond\Infrastructure\Models\ContentTag\ContentTag;
use Diamond\Infrastructure\Models\ContentTag\ContentTagQuery;
use Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel;
use Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery;
use Diamond\Infrastructure\Models\ContentTagRel\Base\ContentTagRel as BaseContentTagRel;
use Diamond\Infrastructure\Models\ContentTagRel\Map\ContentTagRelTableMap;
use Diamond\Infrastructure\Models\Content\Map\ContentTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;

/**
 * Base class that represents a row from the '_content' table.
 *
 *
 *
 * @package    propel.generator.Diamond.Infrastructure.Models.Content.Base
 */
abstract class Content implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Diamond\\Infrastructure\\Models\\Content\\Map\\ContentTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string
     */
    protected $title;

    /**
     * The value for the body field.
     *
     * @var        string|null
     */
    protected $body;

    /**
     * The value for the preview field.
     *
     * @var        string|null
     */
    protected $preview;

    /**
     * The value for the datecreate field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $datecreate;

    /**
     * The value for the date field.
     *
     * @var        DateTime
     */
    protected $date;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * The value for the author field.
     *
     * @var        string|null
     */
    protected $author;

    /**
     * The value for the author_id field.
     *
     * @var        int|null
     */
    protected $author_id;

    /**
     * The value for the category_id field.
     *
     * @var        int
     */
    protected $category_id;

    /**
     * @var        ContentCategory
     */
    protected $aContentCategory;

    /**
     * @var        ObjectCollection|ContentTagRel[] Collection to store aggregation of ContentTagRel objects.
     * @phpstan-var ObjectCollection&\Traversable<ContentTagRel> Collection to store aggregation of ContentTagRel objects.
     */
    protected $collContentTagRels;
    protected $collContentTagRelsPartial;

    /**
     * @var        ObjectCollection|ContentTag[] Cross Collection to store aggregation of ContentTag objects.
     * @phpstan-var ObjectCollection&\Traversable<ContentTag> Cross Collection to store aggregation of ContentTag objects.
     */
    protected $collContentTags;

    /**
     * @var bool
     */
    protected $collContentTagsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    // archivable behavior
    protected $archiveOnDelete = true;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ContentTag[]
     * @phpstan-var ObjectCollection&\Traversable<ContentTag>
     */
    protected $contentTagsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ContentTagRel[]
     * @phpstan-var ObjectCollection&\Traversable<ContentTagRel>
     */
    protected $contentTagRelsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Diamond\Infrastructure\Models\Content\Base\Content object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Content</code> instance.  If
     * <code>obj</code> is an instance of <code>Content</code>, delegates to
     * <code>equals(Content)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [body] column value.
     *
     * @return string|null
     */
    public function getBody()
    {
        return $this->body;
    }

    /**
     * Get the [preview] column value.
     *
     * @return string|null
     */
    public function getPreview()
    {
        return $this->preview;
    }

    /**
     * Get the [optionally formatted] temporal [datecreate] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getDatecreate($format = null)
    {
        if ($format === null) {
            return $this->datecreate;
        } else {
            return $this->datecreate instanceof \DateTimeInterface ? $this->datecreate->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [date] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getDate($format = null)
    {
        if ($format === null) {
            return $this->date;
        } else {
            return $this->date instanceof \DateTimeInterface ? $this->date->format($format) : null;
        }
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Get the [author] column value.
     *
     * @return string|null
     */
    public function getAuthor()
    {
        return $this->author;
    }

    /**
     * Get the [author_id] column value.
     *
     * @return int|null
     */
    public function getAuthorId()
    {
        return $this->author_id;
    }

    /**
     * Get the [category_id] column value.
     *
     * @return int
     */
    public function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[ContentTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [title] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[ContentTableMap::COL_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [body] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBody($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->body !== $v) {
            $this->body = $v;
            $this->modifiedColumns[ContentTableMap::COL_BODY] = true;
        }

        return $this;
    }

    /**
     * Set the value of [preview] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPreview($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->preview !== $v) {
            $this->preview = $v;
            $this->modifiedColumns[ContentTableMap::COL_PREVIEW] = true;
        }

        return $this;
    }

    /**
     * Sets the value of [datecreate] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setDatecreate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->datecreate !== null || $dt !== null) {
            if ($this->datecreate === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->datecreate->format("Y-m-d H:i:s.u")) {
                $this->datecreate = $dt === null ? null : clone $dt;
                $this->modifiedColumns[ContentTableMap::COL_DATECREATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [date] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setDate($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->date !== null || $dt !== null) {
            if ($this->date === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->date->format("Y-m-d H:i:s.u")) {
                $this->date = $dt === null ? null : clone $dt;
                $this->modifiedColumns[ContentTableMap::COL_DATE] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Set the value of [active] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[ContentTableMap::COL_ACTIVE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [author] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setAuthor($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->author !== $v) {
            $this->author = $v;
            $this->modifiedColumns[ContentTableMap::COL_AUTHOR] = true;
        }

        return $this;
    }

    /**
     * Set the value of [author_id] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setAuthorId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->author_id !== $v) {
            $this->author_id = $v;
            $this->modifiedColumns[ContentTableMap::COL_AUTHOR_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [category_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCategoryId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->category_id !== $v) {
            $this->category_id = $v;
            $this->modifiedColumns[ContentTableMap::COL_CATEGORY_ID] = true;
        }

        if ($this->aContentCategory !== null && $this->aContentCategory->getId() !== $v) {
            $this->aContentCategory = null;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : ContentTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : ContentTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : ContentTableMap::translateFieldName('Body', TableMap::TYPE_PHPNAME, $indexType)];
            $this->body = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : ContentTableMap::translateFieldName('Preview', TableMap::TYPE_PHPNAME, $indexType)];
            $this->preview = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : ContentTableMap::translateFieldName('Datecreate', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->datecreate = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : ContentTableMap::translateFieldName('Date', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->date = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : ContentTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : ContentTableMap::translateFieldName('Author', TableMap::TYPE_PHPNAME, $indexType)];
            $this->author = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : ContentTableMap::translateFieldName('AuthorId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->author_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : ContentTableMap::translateFieldName('CategoryId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->category_id = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 10; // 10 = ContentTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Infrastructure\\Models\\Content\\Content'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aContentCategory !== null && $this->category_id !== $this->aContentCategory->getId()) {
            $this->aContentCategory = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ContentTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildContentQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aContentCategory = null;
            $this->collContentTagRels = null;

            $this->collContentTags = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Content::setDeleted()
     * @see Content::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildContentQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            // archivable behavior
            if ($ret) {
                if ($this->archiveOnDelete) {
                    // do nothing yet. The object will be archived later when calling ChildContentQuery::delete().
                } else {
                    $deleteQuery->setArchiveOnDelete(false);
                    $this->archiveOnDelete = true;
                }
            }

            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(ContentTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                ContentTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aContentCategory !== null) {
                if ($this->aContentCategory->isModified() || $this->aContentCategory->isNew()) {
                    $affectedRows += $this->aContentCategory->save($con);
                }
                $this->setContentCategory($this->aContentCategory);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->contentTagsScheduledForDeletion !== null) {
                if (!$this->contentTagsScheduledForDeletion->isEmpty()) {
                    $pks = [];
                    foreach ($this->contentTagsScheduledForDeletion as $entry) {
                        $entryPk = [];

                        $entryPk[1] = $this->getId();
                        $entryPk[0] = $entry->getId();
                        $pks[] = $entryPk;
                    }

                    \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);

                    $this->contentTagsScheduledForDeletion = null;
                }

            }

            if ($this->collContentTags) {
                foreach ($this->collContentTags as $contentTag) {
                    if (!$contentTag->isDeleted() && ($contentTag->isNew() || $contentTag->isModified())) {
                        $contentTag->save($con);
                    }
                }
            }


            if ($this->contentTagRelsScheduledForDeletion !== null) {
                if (!$this->contentTagRelsScheduledForDeletion->isEmpty()) {
                    \Diamond\Infrastructure\Models\ContentTagRel\ContentTagRelQuery::create()
                        ->filterByPrimaryKeys($this->contentTagRelsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->contentTagRelsScheduledForDeletion = null;
                }
            }

            if ($this->collContentTagRels !== null) {
                foreach ($this->collContentTagRels as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[ContentTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . ContentTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(ContentTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_BODY)) {
            $modifiedColumns[':p' . $index++]  = '`body`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_PREVIEW)) {
            $modifiedColumns[':p' . $index++]  = '`preview`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_DATECREATE)) {
            $modifiedColumns[':p' . $index++]  = '`datecreate`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_DATE)) {
            $modifiedColumns[':p' . $index++]  = '`date`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_AUTHOR)) {
            $modifiedColumns[':p' . $index++]  = '`author`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_AUTHOR_ID)) {
            $modifiedColumns[':p' . $index++]  = '`author_id`';
        }
        if ($this->isColumnModified(ContentTableMap::COL_CATEGORY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`category_id`';
        }

        $sql = sprintf(
            'INSERT INTO `_content` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`body`':
                        $stmt->bindValue($identifier, $this->body, PDO::PARAM_STR);
                        break;
                    case '`preview`':
                        $stmt->bindValue($identifier, $this->preview, PDO::PARAM_STR);
                        break;
                    case '`datecreate`':
                        $stmt->bindValue($identifier, $this->datecreate ? $this->datecreate->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`date`':
                        $stmt->bindValue($identifier, $this->date ? $this->date->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                    case '`author`':
                        $stmt->bindValue($identifier, $this->author, PDO::PARAM_STR);
                        break;
                    case '`author_id`':
                        $stmt->bindValue($identifier, $this->author_id, PDO::PARAM_INT);
                        break;
                    case '`category_id`':
                        $stmt->bindValue($identifier, $this->category_id, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ContentTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getTitle();

            case 2:
                return $this->getBody();

            case 3:
                return $this->getPreview();

            case 4:
                return $this->getDatecreate();

            case 5:
                return $this->getDate();

            case 6:
                return $this->getActive();

            case 7:
                return $this->getAuthor();

            case 8:
                return $this->getAuthorId();

            case 9:
                return $this->getCategoryId();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['Content'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Content'][$this->hashCode()] = true;
        $keys = ContentTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getBody(),
            $keys[3] => $this->getPreview(),
            $keys[4] => $this->getDatecreate(),
            $keys[5] => $this->getDate(),
            $keys[6] => $this->getActive(),
            $keys[7] => $this->getAuthor(),
            $keys[8] => $this->getAuthorId(),
            $keys[9] => $this->getCategoryId(),
        ];
        if ($result[$keys[4]] instanceof \DateTimeInterface) {
            $result[$keys[4]] = $result[$keys[4]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[5]] instanceof \DateTimeInterface) {
            $result[$keys[5]] = $result[$keys[5]]->format('Y-m-d H:i:s.u');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aContentCategory) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'contentCategory';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_content_category';
                        break;
                    default:
                        $key = 'ContentCategory';
                }

                $result[$key] = $this->aContentCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collContentTagRels) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'contentTagRels';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_content_tag_rels';
                        break;
                    default:
                        $key = 'ContentTagRels';
                }

                $result[$key] = $this->collContentTagRels->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = ContentTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setBody($value);
                break;
            case 3:
                $this->setPreview($value);
                break;
            case 4:
                $this->setDatecreate($value);
                break;
            case 5:
                $this->setDate($value);
                break;
            case 6:
                $this->setActive($value);
                break;
            case 7:
                $this->setAuthor($value);
                break;
            case 8:
                $this->setAuthorId($value);
                break;
            case 9:
                $this->setCategoryId($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = ContentTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setBody($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setPreview($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setDatecreate($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setDate($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setActive($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setAuthor($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setAuthorId($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setCategoryId($arr[$keys[9]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(ContentTableMap::DATABASE_NAME);

        if ($this->isColumnModified(ContentTableMap::COL_ID)) {
            $criteria->add(ContentTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(ContentTableMap::COL_TITLE)) {
            $criteria->add(ContentTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(ContentTableMap::COL_BODY)) {
            $criteria->add(ContentTableMap::COL_BODY, $this->body);
        }
        if ($this->isColumnModified(ContentTableMap::COL_PREVIEW)) {
            $criteria->add(ContentTableMap::COL_PREVIEW, $this->preview);
        }
        if ($this->isColumnModified(ContentTableMap::COL_DATECREATE)) {
            $criteria->add(ContentTableMap::COL_DATECREATE, $this->datecreate);
        }
        if ($this->isColumnModified(ContentTableMap::COL_DATE)) {
            $criteria->add(ContentTableMap::COL_DATE, $this->date);
        }
        if ($this->isColumnModified(ContentTableMap::COL_ACTIVE)) {
            $criteria->add(ContentTableMap::COL_ACTIVE, $this->active);
        }
        if ($this->isColumnModified(ContentTableMap::COL_AUTHOR)) {
            $criteria->add(ContentTableMap::COL_AUTHOR, $this->author);
        }
        if ($this->isColumnModified(ContentTableMap::COL_AUTHOR_ID)) {
            $criteria->add(ContentTableMap::COL_AUTHOR_ID, $this->author_id);
        }
        if ($this->isColumnModified(ContentTableMap::COL_CATEGORY_ID)) {
            $criteria->add(ContentTableMap::COL_CATEGORY_ID, $this->category_id);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildContentQuery::create();
        $criteria->add(ContentTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Diamond\Infrastructure\Models\Content\Content (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setBody($this->getBody());
        $copyObj->setPreview($this->getPreview());
        $copyObj->setDatecreate($this->getDatecreate());
        $copyObj->setDate($this->getDate());
        $copyObj->setActive($this->getActive());
        $copyObj->setAuthor($this->getAuthor());
        $copyObj->setAuthorId($this->getAuthorId());
        $copyObj->setCategoryId($this->getCategoryId());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getContentTagRels() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addContentTagRel($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Infrastructure\Models\Content\Content Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a ContentCategory object.
     *
     * @param ContentCategory $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setContentCategory(ContentCategory $v = null)
    {
        if ($v === null) {
            $this->setCategoryId(NULL);
        } else {
            $this->setCategoryId($v->getId());
        }

        $this->aContentCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ContentCategory object, it will not be re-added.
        if ($v !== null) {
            $v->addContent($this);
        }


        return $this;
    }


    /**
     * Get the associated ContentCategory object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return ContentCategory The associated ContentCategory object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getContentCategory(?ConnectionInterface $con = null)
    {
        if ($this->aContentCategory === null && ($this->category_id != 0)) {
            $this->aContentCategory = ContentCategoryQuery::create()->findPk($this->category_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aContentCategory->addContents($this);
             */
        }

        return $this->aContentCategory;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName): void
    {
        if ('ContentTagRel' === $relationName) {
            $this->initContentTagRels();
            return;
        }
    }

    /**
     * Clears out the collContentTagRels collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addContentTagRels()
     */
    public function clearContentTagRels()
    {
        $this->collContentTagRels = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collContentTagRels collection loaded partially.
     *
     * @return void
     */
    public function resetPartialContentTagRels($v = true): void
    {
        $this->collContentTagRelsPartial = $v;
    }

    /**
     * Initializes the collContentTagRels collection.
     *
     * By default this just sets the collContentTagRels collection to an empty array (like clearcollContentTagRels());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initContentTagRels(bool $overrideExisting = true): void
    {
        if (null !== $this->collContentTagRels && !$overrideExisting) {
            return;
        }

        $collectionClassName = ContentTagRelTableMap::getTableMap()->getCollectionClassName();

        $this->collContentTagRels = new $collectionClassName;
        $this->collContentTagRels->setModel('\Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel');
    }

    /**
     * Gets an array of ContentTagRel objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildContent is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|ContentTagRel[] List of ContentTagRel objects
     * @phpstan-return ObjectCollection&\Traversable<ContentTagRel> List of ContentTagRel objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getContentTagRels(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collContentTagRelsPartial && !$this->isNew();
        if (null === $this->collContentTagRels || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collContentTagRels) {
                    $this->initContentTagRels();
                } else {
                    $collectionClassName = ContentTagRelTableMap::getTableMap()->getCollectionClassName();

                    $collContentTagRels = new $collectionClassName;
                    $collContentTagRels->setModel('\Diamond\Infrastructure\Models\ContentTagRel\ContentTagRel');

                    return $collContentTagRels;
                }
            } else {
                $collContentTagRels = ContentTagRelQuery::create(null, $criteria)
                    ->filterByContent($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collContentTagRelsPartial && count($collContentTagRels)) {
                        $this->initContentTagRels(false);

                        foreach ($collContentTagRels as $obj) {
                            if (false == $this->collContentTagRels->contains($obj)) {
                                $this->collContentTagRels->append($obj);
                            }
                        }

                        $this->collContentTagRelsPartial = true;
                    }

                    return $collContentTagRels;
                }

                if ($partial && $this->collContentTagRels) {
                    foreach ($this->collContentTagRels as $obj) {
                        if ($obj->isNew()) {
                            $collContentTagRels[] = $obj;
                        }
                    }
                }

                $this->collContentTagRels = $collContentTagRels;
                $this->collContentTagRelsPartial = false;
            }
        }

        return $this->collContentTagRels;
    }

    /**
     * Sets a collection of ContentTagRel objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $contentTagRels A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setContentTagRels(Collection $contentTagRels, ?ConnectionInterface $con = null)
    {
        /** @var ContentTagRel[] $contentTagRelsToDelete */
        $contentTagRelsToDelete = $this->getContentTagRels(new Criteria(), $con)->diff($contentTagRels);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->contentTagRelsScheduledForDeletion = clone $contentTagRelsToDelete;

        foreach ($contentTagRelsToDelete as $contentTagRelRemoved) {
            $contentTagRelRemoved->setContent(null);
        }

        $this->collContentTagRels = null;
        foreach ($contentTagRels as $contentTagRel) {
            $this->addContentTagRel($contentTagRel);
        }

        $this->collContentTagRels = $contentTagRels;
        $this->collContentTagRelsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseContentTagRel objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseContentTagRel objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countContentTagRels(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collContentTagRelsPartial && !$this->isNew();
        if (null === $this->collContentTagRels || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collContentTagRels) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getContentTagRels());
            }

            $query = ContentTagRelQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByContent($this)
                ->count($con);
        }

        return count($this->collContentTagRels);
    }

    /**
     * Method called to associate a ContentTagRel object to this object
     * through the ContentTagRel foreign key attribute.
     *
     * @param ContentTagRel $l ContentTagRel
     * @return $this The current object (for fluent API support)
     */
    public function addContentTagRel(ContentTagRel $l)
    {
        if ($this->collContentTagRels === null) {
            $this->initContentTagRels();
            $this->collContentTagRelsPartial = true;
        }

        if (!$this->collContentTagRels->contains($l)) {
            $this->doAddContentTagRel($l);

            if ($this->contentTagRelsScheduledForDeletion and $this->contentTagRelsScheduledForDeletion->contains($l)) {
                $this->contentTagRelsScheduledForDeletion->remove($this->contentTagRelsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ContentTagRel $contentTagRel The ContentTagRel object to add.
     */
    protected function doAddContentTagRel(ContentTagRel $contentTagRel): void
    {
        $this->collContentTagRels[]= $contentTagRel;
        $contentTagRel->setContent($this);
    }

    /**
     * @param ContentTagRel $contentTagRel The ContentTagRel object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeContentTagRel(ContentTagRel $contentTagRel)
    {
        if ($this->getContentTagRels()->contains($contentTagRel)) {
            $pos = $this->collContentTagRels->search($contentTagRel);
            $this->collContentTagRels->remove($pos);
            if (null === $this->contentTagRelsScheduledForDeletion) {
                $this->contentTagRelsScheduledForDeletion = clone $this->collContentTagRels;
                $this->contentTagRelsScheduledForDeletion->clear();
            }
            $this->contentTagRelsScheduledForDeletion[]= clone $contentTagRel;
            $contentTagRel->setContent(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Content is new, it will return
     * an empty collection; or if this Content has previously
     * been saved, it will retrieve related ContentTagRels from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Content.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ContentTagRel[] List of ContentTagRel objects
     * @phpstan-return ObjectCollection&\Traversable<ContentTagRel}> List of ContentTagRel objects
     */
    public function getContentTagRelsJoinContentTag(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ContentTagRelQuery::create(null, $criteria);
        $query->joinWith('ContentTag', $joinBehavior);

        return $this->getContentTagRels($query, $con);
    }

    /**
     * Clears out the collContentTags collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addContentTags()
     */
    public function clearContentTags()
    {
        $this->collContentTags = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Initializes the collContentTags crossRef collection.
     *
     * By default this just sets the collContentTags collection to an empty collection (like clearContentTags());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initContentTags()
    {
        $collectionClassName = ContentTagRelTableMap::getTableMap()->getCollectionClassName();

        $this->collContentTags = new $collectionClassName;
        $this->collContentTagsPartial = true;
        $this->collContentTags->setModel('\Diamond\Infrastructure\Models\ContentTag\ContentTag');
    }

    /**
     * Checks if the collContentTags collection is loaded.
     *
     * @return bool
     */
    public function isContentTagsLoaded(): bool
    {
        return null !== $this->collContentTags;
    }

    /**
     * Gets a collection of ContentTag objects related by a many-to-many relationship
     * to the current object by way of the _content_tag_rel cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildContent is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param ConnectionInterface $con Optional connection object
     *
     * @return ObjectCollection|ContentTag[] List of ContentTag objects
     * @phpstan-return ObjectCollection&\Traversable<ContentTag> List of ContentTag objects
     */
    public function getContentTags(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collContentTagsPartial && !$this->isNew();
        if (null === $this->collContentTags || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collContentTags) {
                    $this->initContentTags();
                }
            } else {

                $query = ContentTagQuery::create(null, $criteria)
                    ->filterByContent($this);
                $collContentTags = $query->find($con);
                if (null !== $criteria) {
                    return $collContentTags;
                }

                if ($partial && $this->collContentTags) {
                    //make sure that already added objects gets added to the list of the database.
                    foreach ($this->collContentTags as $obj) {
                        if (!$collContentTags->contains($obj)) {
                            $collContentTags[] = $obj;
                        }
                    }
                }

                $this->collContentTags = $collContentTags;
                $this->collContentTagsPartial = false;
            }
        }

        return $this->collContentTags;
    }

    /**
     * Sets a collection of ContentTag objects related by a many-to-many relationship
     * to the current object by way of the _content_tag_rel cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $contentTags A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setContentTags(Collection $contentTags, ?ConnectionInterface $con = null)
    {
        $this->clearContentTags();
        $currentContentTags = $this->getContentTags();

        $contentTagsScheduledForDeletion = $currentContentTags->diff($contentTags);

        foreach ($contentTagsScheduledForDeletion as $toDelete) {
            $this->removeContentTag($toDelete);
        }

        foreach ($contentTags as $contentTag) {
            if (!$currentContentTags->contains($contentTag)) {
                $this->doAddContentTag($contentTag);
            }
        }

        $this->collContentTagsPartial = false;
        $this->collContentTags = $contentTags;

        return $this;
    }

    /**
     * Gets the number of ContentTag objects related by a many-to-many relationship
     * to the current object by way of the _content_tag_rel cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param bool $distinct Set to true to force count distinct
     * @param ConnectionInterface $con Optional connection object
     *
     * @return int The number of related ContentTag objects
     */
    public function countContentTags(?Criteria $criteria = null, $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collContentTagsPartial && !$this->isNew();
        if (null === $this->collContentTags || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collContentTags) {
                return 0;
            } else {

                if ($partial && !$criteria) {
                    return count($this->getContentTags());
                }

                $query = ContentTagQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByContent($this)
                    ->count($con);
            }
        } else {
            return count($this->collContentTags);
        }
    }

    /**
     * Associate a ContentTag to this object
     * through the _content_tag_rel cross reference table.
     *
     * @param ContentTag $contentTag
     * @return ChildContent The current object (for fluent API support)
     */
    public function addContentTag(ContentTag $contentTag)
    {
        if ($this->collContentTags === null) {
            $this->initContentTags();
        }

        if (!$this->getContentTags()->contains($contentTag)) {
            // only add it if the **same** object is not already associated
            $this->collContentTags->push($contentTag);
            $this->doAddContentTag($contentTag);
        }

        return $this;
    }

    /**
     *
     * @param ContentTag $contentTag
     */
    protected function doAddContentTag(ContentTag $contentTag)
    {
        $contentTagRel = new ContentTagRel();

        $contentTagRel->setContentTag($contentTag);

        $contentTagRel->setContent($this);

        $this->addContentTagRel($contentTagRel);

        // set the back reference to this object directly as using provided method either results
        // in endless loop or in multiple relations
        if (!$contentTag->isContentsLoaded()) {
            $contentTag->initContents();
            $contentTag->getContents()->push($this);
        } elseif (!$contentTag->getContents()->contains($this)) {
            $contentTag->getContents()->push($this);
        }

    }

    /**
     * Remove contentTag of this object
     * through the _content_tag_rel cross reference table.
     *
     * @param ContentTag $contentTag
     * @return ChildContent The current object (for fluent API support)
     */
    public function removeContentTag(ContentTag $contentTag)
    {
        if ($this->getContentTags()->contains($contentTag)) {
            $contentTagRel = new ContentTagRel();
            $contentTagRel->setContentTag($contentTag);
            if ($contentTag->isContentsLoaded()) {
                //remove the back reference if available
                $contentTag->getContents()->removeObject($this);
            }

            $contentTagRel->setContent($this);
            $this->removeContentTagRel(clone $contentTagRel);
            $contentTagRel->clear();

            $this->collContentTags->remove($this->collContentTags->search($contentTag));

            if (null === $this->contentTagsScheduledForDeletion) {
                $this->contentTagsScheduledForDeletion = clone $this->collContentTags;
                $this->contentTagsScheduledForDeletion->clear();
            }

            $this->contentTagsScheduledForDeletion->push($contentTag);
        }


        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aContentCategory) {
            $this->aContentCategory->removeContent($this);
        }
        $this->id = null;
        $this->title = null;
        $this->body = null;
        $this->preview = null;
        $this->datecreate = null;
        $this->date = null;
        $this->active = null;
        $this->author = null;
        $this->author_id = null;
        $this->category_id = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
            if ($this->collContentTagRels) {
                foreach ($this->collContentTagRels as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collContentTags) {
                foreach ($this->collContentTags as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collContentTagRels = null;
        $this->collContentTags = null;
        $this->aContentCategory = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(ContentTableMap::DEFAULT_STRING_FORMAT);
    }

    // archivable behavior

    /**
     * Get an archived version of the current object.
     *
     * @param ConnectionInterface|null $con Optional connection object
     *
     * @return ChildContentArchive An archive object, or null if the current object was never archived
     */
    public function getArchive(?ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            return null;
        }
        $archive = ChildContentArchiveQuery::create()
            ->filterByPrimaryKey($this->getPrimaryKey())
            ->findOne($con);

        return $archive;
    }
    /**
     * Copy the data of the current object into a $archiveTablePhpName archive object.
     * The archived object is then saved.
     * If the current object has already been archived, the archived object
     * is updated and not duplicated.
     *
     * @param ConnectionInterface|null $con Optional connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException If the object is new
     *
     * @return ChildContentArchive The archive object based on this object
     */
    public function archive(?ConnectionInterface $con = null)
    {
        if ($this->isNew()) {
            throw new PropelException('New objects cannot be archived. You must save the current object before calling archive().');
        }
        $archive = $this->getArchive($con);
        if (!$archive) {
            $archive = new ChildContentArchive();
            $archive->setPrimaryKey($this->getPrimaryKey());
        }
        $this->copyInto($archive, $deepCopy = false, $makeNew = false);
        $archive->setArchivedAt(time());
        $archive->save($con);

        return $archive;
    }

    /**
     * Revert the the current object to the state it had when it was last archived.
     * The object must be saved afterwards if the changes must persist.
     *
     * @param ConnectionInterface|null $con Optional connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException If the object has no corresponding archive.
     *
     * @return $this The current object (for fluent API support)
     */
    public function restoreFromArchive(?ConnectionInterface $con = null)
    {
        $archive = $this->getArchive($con);
        if (!$archive) {
            throw new PropelException('The current object has never been archived and cannot be restored');
        }
        $this->populateFromArchive($archive);

        return $this;
    }

    /**
     * Populates the the current object based on a $archiveTablePhpName archive object.
     *
     * @param ChildContentArchive $archive An archived object based on the same class
      * @param bool $populateAutoIncrementPrimaryKeys
     *               If true, autoincrement columns are copied from the archive object.
     *               If false, autoincrement columns are left intact.
      *
     * @return ChildContent The current object (for fluent API support)
     */
    public function populateFromArchive($archive, bool $populateAutoIncrementPrimaryKeys = false)
    {
        if ($populateAutoIncrementPrimaryKeys) {
            $this->setId($archive->getId());
        }
        $this->setTitle($archive->getTitle());
        $this->setBody($archive->getBody());
        $this->setPreview($archive->getPreview());
        $this->setDatecreate($archive->getDatecreate());
        $this->setDate($archive->getDate());
        $this->setActive($archive->getActive());
        $this->setAuthor($archive->getAuthor());
        $this->setAuthorId($archive->getAuthorId());
        $this->setCategoryId($archive->getCategoryId());

        return $this;
    }

    /**
     * Removes the object from the database without archiving it.
     *
     * @param ConnectionInterface|null $con Optional connection object
     *
     * @return $this|ChildContent The current object (for fluent API support)
     */
    public function deleteWithoutArchive(?ConnectionInterface $con = null)
    {
        $this->archiveOnDelete = false;

        return $this->delete($con);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
