<?php

namespace Diamond\Domain\User;

use Core\Repository\DropDownInterface;
use Diamond\Domain\User\Contracts\UserEntityInterface;
use Repo\Concrete\AbstractCollection;

class UserCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return UserEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getNameWithEmail();
        }
        return $ar;
    }

    public function getIds(): array
    {
        $ids = [];
        foreach ($this->_entities as $price) {
            $ids[] = $price->getId();
        }
        return $ids;
    }

}