<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.08.2020
 * Time: 20:33
 */

namespace Diamond\Domain\User\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface UserCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string;

    /**
     * @return int|null
     */
    public function getFilterByGroupId(): ?int;

    /**
     * @return string|null
     */
    public function getSearchByEmail(): ?string;

    /**
     * @return string|null
     */
    public function getFilterByEmail(): ?string;


    /**
     * @return int|null
     */
    public function getFilterById(): ?int;

    /**
     * @return string|null
     */
    public function getSortByGroupId(): ?string;
    public function getSortById():?string ;
    public function getSortByName():?string ;
    public function getSortByEmail():?string ;

    public function setBlocked(?bool $blocked): UserCriteriaInterface;
    public function getBlocked(): ?bool;

}