<?php


namespace Diamond\Domain\MailingList;

use Diamond\Infrastructure\Models\MailingRequest\MailingRequest;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient;
use Propel\Runtime\Collection\Collection;

/**
 * VolueObject
 * Class ProgressData
 * @package Diamond\Domain\MailingList
 */
final class ProgressData
{

    /**
     * @var string
     */
    protected $body;

    /**
     * @var Collection
     */
    protected $emails;

    /**
     * @var string
     */
    protected $subject;

    protected $lastRequest;

    public function __construct(Collection $items, MailingRequest $request)
    {
        $this->body = $request->getBody();
        $this->subject = $request->getSubject();

        $this->emails = $items;
        $this->lastRequest = $request;
    }

    /**
     * @return MailingRequest|null
     */
    public function getLastRequest(): ?MailingRequest
    {
        return $this->lastRequest;
    }


    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @return int
     */
    public function getCount(): int
    {
        return $this->emails->count();
    }

    /**
     * @return string
     */
    public function getBody(): string
    {
        return $this->body;
    }

    /**
     * @return Collection
     */
    public function getEmails(): Collection
    {
        return $this->emails;
    }

    /**
     * percent
     * @return int
     */
    public function getProgress(): int
    {
        $emails = $this->emails;
        $sending = 0;
        foreach ($emails as $email) {
            if ($email->getSendingAt() !== null) {
                $sending++;
            }
        }
        $count = $emails->count();

        $progress = round($sending / $count * 100);

        return $progress;
    }

    public function getViews(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if ($email->getViewedAt() !== null) {
                $views++;
            }
        }
        return $views;
    }


    public function getSending(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if ($email->getSendingAt() !== null) {
                $views++;
            }
        }
        return $views;
    }
}