<?php


namespace Diamond\Application\Notification\SendEmail;


use Diamond\Application\Mailing\MailingFactory;
use Diamond\Config\Mail;
use Nette\Mail\FallbackMailerException;
use Nette\Mail\SendException;
use Nette\Mail\Message;

class SendEmailHandler
{

    public function __construct(private Mail $mailConfig, private MailingFactory $mailerFactory)
    {
    }

    /**
     * @param SendEmailCommand $command
     */
    public function handle(SendEmailCommand $command): void
    {
        if (!$this->mailConfig->getMail_from()) {
            throw new SendEmailException('mail from not set in configs');
        }

        $mailer = $this->mailerFactory->buildFallbackMailer();

        $message = $command->getMessage();
        $email = $command->getEmail();

        $message = (new Message())
            ->setFrom($this->mailConfig->getMail_from())
            ->addTo($email)
            ->setSubject($message->getSubject())
            ->setHtmlBody($message->getContent())
        ;

        foreach ($command->getMessage()->getAttachFilesLinks() as $file){
            $message->addAttachment($file);
        }

        try {
            $mailer->send($message);
        } catch (FallbackMailerException $ex) {

            foreach ($ex->failures as $failure) {
                if (strpos($failure->getMessage(), 'account is disabled') ||
                    strpos($failure->getMessage(), 'invalid mailbox') ||
                    strpos($failure->getMessage(), 'verification failed')
                ) {
                    throw new EmailAccountDisabledException($failure->getMessage(), $email);
                }
            }

            if(isset($failure)){
                throw new SendEmailException($failure);
            }

        } catch (SendException $ex) {
            throw new SendEmailException($ex->getMessage());
        }
    }
}