<?php

namespace Diamond\Modules\AdminTreeMenu;

use Core\Breadcrumb\Breadcrumb;
use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Core\Menu\AdminMenu;
use Core\ModuleController;
use Diamond\Application\Content\ContentService;
use Diamond\Application\User\UserService;


class AdminTreeMenu extends ModuleController implements RequestAwareInterface
{

    use RequestAwareTrait;

    public string|null $name = null;

    public function __construct(private AdminMenu      $adminMenu, private Breadcrumb $breadcrumb,
                                private ContentService $contentService, private UserService $userService)
    {
    }

    public function process(): string
    {

        $url = $this->request->getPathInfo();

        $groups = $this->adminMenu->getItems();

        $this->breadcrumb->home_link = admin_path('/diamond/system/dashboard');

        foreach ($groups as $key => $group) {

            foreach ($group as $key2 => $item) {
//
                $onlyView = empty($item['view_blocked']) === true;
                $blockedUrl = isset($item['url']) && $this->userService->isUserAccessUrl($item['url'], 'read') === false;
                if (
                    //некоторые пункты могут быть видны но неактивны
                    $onlyView && $blockedUrl
                ) {
                    unset($groups[$key][$key2]);
                }
                elseif ($onlyView === false && $blockedUrl ) {
                    $groups[$key][$key2]['only_view'] = true;
                }


                if (isset($item['items'])) {
                    foreach ($item['items'] as $key3 => $sub) {

                        $subBlocked = isset($sub['url']) && $this->userService->isUserAccessUrl($sub['url'], 'read');

                        if ($subBlocked === false) {
                            unset($groups[$key][$key2]['items'][$key3]);
                        } elseif (isset($sub['url']) && $sub['url'] === $url || (isset($sub['related']) && in_array($url, $sub['related']))) {
                            $groups[$key][$key2]['items'][$key3]['current'] = true;
                            $groups[$key][$key2]['current'] = true;
                            $this->breadcrumb->addCrumb($sub['label'], $sub['url']);
                        }

                    }

                } elseif ($item['url'] === $url || (isset($item['related']) && in_array($url, $item['related']))) {
                    $groups[$key][$key2]['current'] = true;
                }


            }
        }

        foreach ($groups as $k => $group) {
            foreach ($group as $k2 => $subGroup) {

                if( isset($subGroup['view_blocked']) && $subGroup['view_blocked'] === true &&
                    (isset($subGroup['items']) && count($subGroup['items']) === 0) ){
                    $groups[$k][$k2]['only_view'] = true;
                }
                elseif ((isset($subGroup['items']) && count($subGroup['items']) === 0)
                ) {
                    unset($groups[$k][$k2]);
                }
            }
        }


        //dd($groups);

//        foreach ($groups as $k => $group) {
//            foreach ($group as $k2 => $subGroup) {
//
//                $countItems = isset($subGroup['items']) && count($subGroup['items']) > 0;
//
//
//                if (isset($subGroup['view_blocked']) && $subGroup['view_blocked']===true && !$countItems && empty($subGroup['url'])) {
//                    $subGroup['only_view'] = true;
//
//                    //continue;
//                }
//
//                if(!$countItems) {
//                   unset($groups[$k][$k2]);
//                }
//            }
//        }


//        foreach ($groups as $k => $group) {
//
//
//
//            foreach ($group as $k2 => $subGroup) {
//
//                $countItems = isset($subGroup['items']) && count($subGroup['items']) > 0;
//
//                if (empty($subGroup['url']) && !empty($subGroup['view_blocked']) && $countItems === false) {
//
//                    //dump($subGroup['url']??'', $subGroup['label'], !empty($subGroup['view_blocked']), $countItems,'-------');
//
//                    $groups[$k][$k2]['only_view'] = true;
//                }
//                else if(empty($groups[$k][$k2]['only_view']) && $countItems === false) {
//                    //dump($groups[''])
//                    //unset($groups[$k][$k2]);
//                }
//            }
//        }


        foreach ($groups as $k => $group) {
            if (!count($group)) {
                unset($groups[$k]);
            }
        }

        $widget = $this->contentService->getPromoBlockContentByCode('admin_menu_bottom');

        return $this->render([
            'items' => $groups,
            'admin_menu_bottom' => $widget > '' ? $this->twig->createTemplate($widget, md5(microtime()))->render() : null
        ]);
    }

}