<?php

namespace Diamond\Modules\AdminSliders;

use ActiveTable\ColumnTable;
use Core\Form\Control\Switchery;
use Core\Form\NiftyControlBuilder;
use Core\ModuleController;
use Diamond\Domain\SliderImage\Contracts\SliderImageEntityInterface;
use Diamond\Helpers\Form;
use Diamond\Repositories\SliderImage\SliderImageCriteria;
use Diamond\Repositories\SliderImage\SliderImageRepository;
use Diamond\Application\Imaging\ImagingService as Imaging;
use DiamondTable\TableFactory;

/**
 * Description of AdminSliders
 *
 * @author Diamond Code Generator
 */
class AdminSliders extends ModuleController
{


    public function __construct(private SliderImageRepository $sliderImageRepository,
                                private  TableFactory $tableFactory,
                                protected NiftyControlBuilder $controlBuilder,
                                private Imaging $imagingUseCase)
    {}
    
    public function process(): string
    {
        if (!is_dir($this->imagingUseCase->getSliderImageDir())) {
            return Form::buildAnnouncementMessage(
                'Путь к изображениям слайдера не настроен. ' . anchor(admin_path('/diamond/settings/content'), 'Настроить'));
        }


        $table = $this->tableFactory->buildAdminTable(
            $this->sliderImageRepository,
            SliderImageCriteria::create(),
            'Добавить изображение'
        );

        $table
            ->setDefaultSortColumn('id','DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('code', 'Группа'))
            )
            ->addColumn(
                (new ColumnTable('title', 'Заголовок изображения'))
            )
            ->addColumn(
                (new ColumnTable('link', 'Ссылка'))
            )
            ->addColumn(
                (new ColumnTable('bigImage', 'Изображение большое'))
                    ->setFormat($this, 'formatBigImage')
            )
            ->addColumn(
                (new ColumnTable('middleImage', 'Изображение среднее'))
                    ->setFormat($this, 'formatMiddleImage')
            )
            ->addColumn(
                (new ColumnTable('active', 'Активен'))
                    ->setFormat($this, 'formatActive')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this->tableFactory, 'formatActions')
            );

        $imgUpload = $this
            ->controlBuilder
            ->buildImgUpload('bigImage', $this->imagingUseCase->getSliderImageDir(), true)
            ->setPreviewImage(true);
        $imgUploadM = $this
            ->controlBuilder
            ->buildImgUpload('middleImage', $this->imagingUseCase->getSliderImageDir(), true)
            ->setPreviewImage(true);


        $table
            ->addField(
                $this->controlBuilder->buildInput('title'), true, null, 'будет указана в alt атрибуте'
            )
            ->addField(
                $this->controlBuilder->buildInput('code'), false, null, 'Группировка по названию слайдера'
            )
            ->addField(
                $this->controlBuilder->buildInput('link'), false, null, 'сылка на внешний или внутрений ресурс'
            )
            ->addField(
                $imgUpload, false, null, 'рекомендуемая ширина 1440px'
            )
            ->addField(
                $imgUploadM, false, null, 'рекомендуемая ширина 768px'
            )
            ->addField(
                $this->controlBuilder->buildNiftySimpleSwitchery('active',1,0)
            );

        $this->tableFactory->prepareAdminTableForDomain($table);

        $file = $imgUpload->UploadImage();

        /**
         * @todo убрать костыль
         */
        if ($file) {
            $table->addContent(Form::buildSuccessMessage(sprintf('Большое изображение %s успешно сохранено', $file)));
        } elseif ($imgUpload->deleteImage()) {
            $table->addContent(Form::buildSuccessMessage('Большое изображение успешно удалено'));
        }

        //---------------------------------------------------
        $file = $imgUploadM->UploadImage();

        if ($file) {
            $table->addContent(Form::buildSuccessMessage(sprintf('Большое изображение %s успешно сохранено', $file)));
        } elseif ($imgUploadM->deleteImage()) {
            $table->addContent(Form::buildSuccessMessage('Большое изображение успешно удалено'));
        }

        return $table->render();
    }

    public function formatBigImage(SliderImageEntityInterface $entity): string
    {
        if(!$entity->getbigimage()){
            return '';
        }

        $path = $this->imagingUseCase->getPublicSliderImageDir() . $entity->getbigimage();

       return '<img class="img-sm img-circle" src="' . $path . '" />';
    }

    public function formatMiddleImage(SliderImageEntityInterface $entity): string
    {
        if(!$entity->getMiddleImage()){
            return '';
        }

        $path = $this->imagingUseCase->getPublicSliderImageDir() . $entity->getMiddleImage();

        return '<img class="img-sm img-circle" src="' . $path . '" />';
    }

    public function formatActive(SliderImageEntityInterface $entity): string
    {
        $data = [
            'class' => self::class,
            'id' => $entity->getId(),
            'fn' => 'changeActive'
        ];
        return (new Switchery($data, $entity->getActive() === 1))->render();
    }

    public function changeActive(int $id, bool $checked): void
    {
        $item = $this->sliderImageRepository->findById($id);
        $item->setActive($checked === true ? 1 : 0);
        $this->sliderImageRepository->save($item);
    }
}               