<?php

namespace Diamond\Modules\AdminMailingSubscribers;


use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Diamond\Application\Mailing\MailingService;
use Diamond\Domain\MailingSubscriber\Contracts\MailingSubscriberEntityInterface;
use Diamond\Infrastructure\Models\Mailing\Mailing;
use Diamond\Repositories\MailingSubscriber\MailingSubscriberCriteria;
use Diamond\Repositories\MailingSubscriber\MailingSubscriberRepository;
use DiamondTable\TableFactory;

/**
 * Description of AdminMailingSubscribers
 *
 * @author Diamond Code Generator
 */
class AdminMailingSubscribers extends \Core\ModuleController
{

    protected $repository;
    protected $tableFactory;
    protected $controlBuilder;
    protected $mailingService;

    /**
     * AdminMailingSubscribers constructor.
     * @param MailingSubscriberRepository $mailingSubscriberRepository
     * @param TableFactory $tableFactory
     * @param MailingService $mailingService
     * @param ControlBuilder $controlBuilder
     */
    public function __construct(MailingSubscriberRepository $mailingSubscriberRepository,
                                TableFactory $tableFactory,
                                MailingService $mailingService,
                                ControlBuilder $controlBuilder)
    {
        $this->repository = $mailingSubscriberRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->mailingService = $mailingService;
    }


    /**
     * @return string
     * @throws \ReflectionException
     */
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->repository, MailingSubscriberCriteria::create());

        $table
            ->setDefaultSortColumn('id','DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
            )
            ->addColumn(
                (new ColumnTable('fn', 'Функция'))
                    ->setFormat($this, 'columnFn')
            )
            ->addColumn(
                (new ColumnTable('customMails', 'Дополнительные emails'))
            )
            ->addColumn(
                (new ColumnTable('ignoreMails', 'Игнорируемые emails'))
            )
            ->addColumn(
                (new ColumnTable('count', 'Кол-во'))->setFormat($this,'formatCount')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInput('title'), true
            )
            ->addField(
                $this->controlBuilder->buildDropdownUniform('fn', $this->mailingService->getRules()), true
            )
            ->addField(
                $this->controlBuilder->buildTextArea('customMails'), false, null, 'Любые адреса, через точку с запятой'
            )
            ->addField(
                $this->controlBuilder->buildTextArea('ignoreMails'), false, null, 'Через точку с запятой'
            );

        return $table->render();
    }

    /**
     * @param MailingSubscriberEntityInterface $sub
     * @return string
     */
    public function columnFn(MailingSubscriberEntityInterface $sub): string
    {
        $data = $this->mailingService->getRules();
        return $data[$sub->getFn()]??$sub->getFn();
    }

    public function formatCount(MailingSubscriberEntityInterface $sub): string
    {
        $mails = $this->mailingService->getSubscribeEmails((new Mailing())->setMailingSubscriber($sub));

        return (string) count($mails);

    }

}               