<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 17.06.2020
 * Time: 9:42
 */

namespace Diamond\Controllers;


use Core\BaseController;
use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Diamond\Application\User\UserService;

use Symfony\Component\HttpFoundation\Session\Session;

class FileManagerController extends BaseController implements RequestAwareInterface
{

    use RequestAwareTrait;

    protected $userService;

    /**
     * FileManager constructor.
     * @param Session $session
     */
    public function __construct( UserService $userService)
    {
        $this->userService = $userService;
    }

    /**
     * @return \Response
     */
    public function action()
    {
        $user = $this->userService->getAuthUser();

        if ($user && preg_match('~.*\/(.*?)$~', $this->request->getPathInfo(), $m)) {

            require_once(BASEPATH . '/vendor/diamond/widgets/assets/jquery/filemanager/' . $m[1] . '.php');
        }

       return new \Response('',404);
    }

}