<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 21.08.2020
 * Time: 23:45
 */

namespace Diamond\Repositories\UserGroup;


use Diamond\Domain\UserGroup\Contracts\UserGroupCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class UserGroupCriteria extends AbstractCriteria implements UserGroupCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $filterByCode;

    /**
     * @var string|null
     */
    protected $filterByName;

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    /**
     * @param string|null $filterByCode
     * @return UserGroupCriteria
     */
    public function setFilterByCode(?string $filterByCode): UserGroupCriteria
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return UserGroupCriteria
     */
    public function setFilterByName(?string $filterByName): UserGroupCriteria
    {
        $this->filterByName = $filterByName;
        return $this;
    }



    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return UserGroupCriteria
     */
    public function setSearchByName(?string $searchByName): UserGroupCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return UserGroupCriteria
     */
    public static function create()
    {
        return new self();
    }


}