<?php

namespace Diamond\Repositories\Report;


use Diamond\Domain\Report\Contracts\ReportCriteriaInterface;
use Diamond\Domain\Report\ReportCollection;
use Diamond\Infrastructure\Models\Report\Report;
use Diamond\Infrastructure\Models\Report\ReportQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class ReportRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    public static function createEntity(): EntityInterface
    {
        return new Report();
    }

    /**
     * @param PaginationInterface|ReportCriteriaInterface $criteria
     * @param ModelCriteria|ReportQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByCode()!==null)
            ->filterByCode($criteria->getFilterByCode())
            ->_endif()
            ;
    }


    protected function createCollection(): CollectionInterface
    {
        return new ReportCollection();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return ReportQuery::create();
    }

}