<?php

namespace Diamond\Infrastructure\Models\Domain\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\Domain\Domain as ChildDomain;
use Diamond\Infrastructure\Models\Domain\DomainQuery as ChildDomainQuery;
use Diamond\Infrastructure\Models\Domain\Map\DomainTableMap;
use Diamond\Infrastructure\Models\ImageSlider\ImageSlider;
use Diamond\Infrastructure\Models\ImageSlider\ImageSliderQuery;
use Diamond\Infrastructure\Models\ImageSlider\Base\ImageSlider as BaseImageSlider;
use Diamond\Infrastructure\Models\ImageSlider\Map\ImageSliderTableMap;
use Diamond\Infrastructure\Models\Menu\Menu;
use Diamond\Infrastructure\Models\Menu\MenuQuery;
use Diamond\Infrastructure\Models\Menu\Base\Menu as BaseMenu;
use Diamond\Infrastructure\Models\Menu\Map\MenuTableMap;
use Diamond\Infrastructure\Models\Page\Page;
use Diamond\Infrastructure\Models\Page\PageQuery;
use Diamond\Infrastructure\Models\Page\Base\Page as BasePage;
use Diamond\Infrastructure\Models\Page\Map\PageTableMap;
use Diamond\Infrastructure\Models\Promoblock\Promoblock;
use Diamond\Infrastructure\Models\Promoblock\PromoblockQuery;
use Diamond\Infrastructure\Models\Promoblock\Base\Promoblock as BasePromoblock;
use Diamond\Infrastructure\Models\Promoblock\Map\PromoblockTableMap;
use Diamond\Infrastructure\Models\Template\Template;
use Diamond\Infrastructure\Models\Template\TemplateQuery;
use Diamond\Infrastructure\Models\Template\Base\Template as BaseTemplate;
use Diamond\Infrastructure\Models\Template\Map\TemplateTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the '_domains' table.
 *
 *
 *
 * @package    propel.generator.Diamond.Infrastructure.Models.Domain.Base
 */
abstract class Domain implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Diamond\\Infrastructure\\Models\\Domain\\Map\\DomainTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     *
     * @var        string|null
     */
    protected $name;

    /**
     * The value for the lang field.
     *
     * @var        string|null
     */
    protected $lang;

    /**
     * The value for the domain field.
     *
     * @var        string|null
     */
    protected $domain;

    /**
     * @var        ObjectCollection|Menu[] Collection to store aggregation of Menu objects.
     * @phpstan-var ObjectCollection&\Traversable<Menu> Collection to store aggregation of Menu objects.
     */
    protected $collMenus;
    protected $collMenusPartial;

    /**
     * @var        ObjectCollection|Page[] Collection to store aggregation of Page objects.
     * @phpstan-var ObjectCollection&\Traversable<Page> Collection to store aggregation of Page objects.
     */
    protected $collPages;
    protected $collPagesPartial;

    /**
     * @var        ObjectCollection|Promoblock[] Collection to store aggregation of Promoblock objects.
     * @phpstan-var ObjectCollection&\Traversable<Promoblock> Collection to store aggregation of Promoblock objects.
     */
    protected $collPromoblocks;
    protected $collPromoblocksPartial;

    /**
     * @var        ObjectCollection|Template[] Collection to store aggregation of Template objects.
     * @phpstan-var ObjectCollection&\Traversable<Template> Collection to store aggregation of Template objects.
     */
    protected $collTemplates;
    protected $collTemplatesPartial;

    /**
     * @var        ObjectCollection|ImageSlider[] Collection to store aggregation of ImageSlider objects.
     * @phpstan-var ObjectCollection&\Traversable<ImageSlider> Collection to store aggregation of ImageSlider objects.
     */
    protected $collImageSliders;
    protected $collImageSlidersPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Menu[]
     * @phpstan-var ObjectCollection&\Traversable<Menu>
     */
    protected $menusScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Page[]
     * @phpstan-var ObjectCollection&\Traversable<Page>
     */
    protected $pagesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Promoblock[]
     * @phpstan-var ObjectCollection&\Traversable<Promoblock>
     */
    protected $promoblocksScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Template[]
     * @phpstan-var ObjectCollection&\Traversable<Template>
     */
    protected $templatesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ImageSlider[]
     * @phpstan-var ObjectCollection&\Traversable<ImageSlider>
     */
    protected $imageSlidersScheduledForDeletion = null;

    /**
     * Initializes internal state of Diamond\Infrastructure\Models\Domain\Base\Domain object.
     */
    public function __construct()
    {
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Domain</code> instance.  If
     * <code>obj</code> is an instance of <code>Domain</code>, delegates to
     * <code>equals(Domain)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [lang] column value.
     *
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }

    /**
     * Get the [domain] column value.
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[DomainTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [name] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[DomainTableMap::COL_NAME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [lang] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setLang($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->lang !== $v) {
            $this->lang = $v;
            $this->modifiedColumns[DomainTableMap::COL_LANG] = true;
        }

        return $this;
    }

    /**
     * Set the value of [domain] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDomain($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->domain !== $v) {
            $this->domain = $v;
            $this->modifiedColumns[DomainTableMap::COL_DOMAIN] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : DomainTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : DomainTableMap::translateFieldName('Name', TableMap::TYPE_PHPNAME, $indexType)];
            $this->name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : DomainTableMap::translateFieldName('Lang', TableMap::TYPE_PHPNAME, $indexType)];
            $this->lang = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : DomainTableMap::translateFieldName('Domain', TableMap::TYPE_PHPNAME, $indexType)];
            $this->domain = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 4; // 4 = DomainTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Diamond\\Infrastructure\\Models\\Domain\\Domain'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(DomainTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildDomainQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collMenus = null;

            $this->collPages = null;

            $this->collPromoblocks = null;

            $this->collTemplates = null;

            $this->collImageSliders = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Domain::setDeleted()
     * @see Domain::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(DomainTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildDomainQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(DomainTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                DomainTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->menusScheduledForDeletion !== null) {
                if (!$this->menusScheduledForDeletion->isEmpty()) {
                    \Diamond\Infrastructure\Models\Menu\MenuQuery::create()
                        ->filterByPrimaryKeys($this->menusScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->menusScheduledForDeletion = null;
                }
            }

            if ($this->collMenus !== null) {
                foreach ($this->collMenus as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->pagesScheduledForDeletion !== null) {
                if (!$this->pagesScheduledForDeletion->isEmpty()) {
                    \Diamond\Infrastructure\Models\Page\PageQuery::create()
                        ->filterByPrimaryKeys($this->pagesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->pagesScheduledForDeletion = null;
                }
            }

            if ($this->collPages !== null) {
                foreach ($this->collPages as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->promoblocksScheduledForDeletion !== null) {
                if (!$this->promoblocksScheduledForDeletion->isEmpty()) {
                    \Diamond\Infrastructure\Models\Promoblock\PromoblockQuery::create()
                        ->filterByPrimaryKeys($this->promoblocksScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->promoblocksScheduledForDeletion = null;
                }
            }

            if ($this->collPromoblocks !== null) {
                foreach ($this->collPromoblocks as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->templatesScheduledForDeletion !== null) {
                if (!$this->templatesScheduledForDeletion->isEmpty()) {
                    \Diamond\Infrastructure\Models\Template\TemplateQuery::create()
                        ->filterByPrimaryKeys($this->templatesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->templatesScheduledForDeletion = null;
                }
            }

            if ($this->collTemplates !== null) {
                foreach ($this->collTemplates as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->imageSlidersScheduledForDeletion !== null) {
                if (!$this->imageSlidersScheduledForDeletion->isEmpty()) {
                    foreach ($this->imageSlidersScheduledForDeletion as $imageSlider) {
                        // need to save related object because we set the relation to null
                        $imageSlider->save($con);
                    }
                    $this->imageSlidersScheduledForDeletion = null;
                }
            }

            if ($this->collImageSliders !== null) {
                foreach ($this->collImageSliders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[DomainTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . DomainTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(DomainTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(DomainTableMap::COL_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`name`';
        }
        if ($this->isColumnModified(DomainTableMap::COL_LANG)) {
            $modifiedColumns[':p' . $index++]  = '`lang`';
        }
        if ($this->isColumnModified(DomainTableMap::COL_DOMAIN)) {
            $modifiedColumns[':p' . $index++]  = '`domain`';
        }

        $sql = sprintf(
            'INSERT INTO `_domains` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`name`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`lang`':
                        $stmt->bindValue($identifier, $this->lang, PDO::PARAM_STR);
                        break;
                    case '`domain`':
                        $stmt->bindValue($identifier, $this->domain, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = DomainTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getName();

            case 2:
                return $this->getLang();

            case 3:
                return $this->getDomain();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['Domain'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Domain'][$this->hashCode()] = true;
        $keys = DomainTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getLang(),
            $keys[3] => $this->getDomain(),
        ];
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->collMenus) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'menus';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_menus';
                        break;
                    default:
                        $key = 'Menus';
                }

                $result[$key] = $this->collMenus->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPages) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'pages';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_pagess';
                        break;
                    default:
                        $key = 'Pages';
                }

                $result[$key] = $this->collPages->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collPromoblocks) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'promoblocks';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_promoblockss';
                        break;
                    default:
                        $key = 'Promoblocks';
                }

                $result[$key] = $this->collPromoblocks->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collTemplates) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'templates';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_templatess';
                        break;
                    default:
                        $key = 'Templates';
                }

                $result[$key] = $this->collTemplates->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collImageSliders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'imageSliders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = '_slider_imagess';
                        break;
                    default:
                        $key = 'ImageSliders';
                }

                $result[$key] = $this->collImageSliders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = DomainTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setLang($value);
                break;
            case 3:
                $this->setDomain($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = DomainTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setName($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setLang($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setDomain($arr[$keys[3]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(DomainTableMap::DATABASE_NAME);

        if ($this->isColumnModified(DomainTableMap::COL_ID)) {
            $criteria->add(DomainTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(DomainTableMap::COL_NAME)) {
            $criteria->add(DomainTableMap::COL_NAME, $this->name);
        }
        if ($this->isColumnModified(DomainTableMap::COL_LANG)) {
            $criteria->add(DomainTableMap::COL_LANG, $this->lang);
        }
        if ($this->isColumnModified(DomainTableMap::COL_DOMAIN)) {
            $criteria->add(DomainTableMap::COL_DOMAIN, $this->domain);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildDomainQuery::create();
        $criteria->add(DomainTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Diamond\Infrastructure\Models\Domain\Domain (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setName($this->getName());
        $copyObj->setLang($this->getLang());
        $copyObj->setDomain($this->getDomain());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getMenus() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addMenu($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPages() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPage($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getPromoblocks() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addPromoblock($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getTemplates() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addTemplate($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getImageSliders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addImageSlider($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Diamond\Infrastructure\Models\Domain\Domain Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName): void
    {
        if ('Menu' === $relationName) {
            $this->initMenus();
            return;
        }
        if ('Page' === $relationName) {
            $this->initPages();
            return;
        }
        if ('Promoblock' === $relationName) {
            $this->initPromoblocks();
            return;
        }
        if ('Template' === $relationName) {
            $this->initTemplates();
            return;
        }
        if ('ImageSlider' === $relationName) {
            $this->initImageSliders();
            return;
        }
    }

    /**
     * Clears out the collMenus collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addMenus()
     */
    public function clearMenus()
    {
        $this->collMenus = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collMenus collection loaded partially.
     *
     * @return void
     */
    public function resetPartialMenus($v = true): void
    {
        $this->collMenusPartial = $v;
    }

    /**
     * Initializes the collMenus collection.
     *
     * By default this just sets the collMenus collection to an empty array (like clearcollMenus());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initMenus(bool $overrideExisting = true): void
    {
        if (null !== $this->collMenus && !$overrideExisting) {
            return;
        }

        $collectionClassName = MenuTableMap::getTableMap()->getCollectionClassName();

        $this->collMenus = new $collectionClassName;
        $this->collMenus->setModel('\Diamond\Infrastructure\Models\Menu\Menu');
    }

    /**
     * Gets an array of Menu objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildDomain is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Menu[] List of Menu objects
     * @phpstan-return ObjectCollection&\Traversable<Menu> List of Menu objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getMenus(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collMenusPartial && !$this->isNew();
        if (null === $this->collMenus || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collMenus) {
                    $this->initMenus();
                } else {
                    $collectionClassName = MenuTableMap::getTableMap()->getCollectionClassName();

                    $collMenus = new $collectionClassName;
                    $collMenus->setModel('\Diamond\Infrastructure\Models\Menu\Menu');

                    return $collMenus;
                }
            } else {
                $collMenus = MenuQuery::create(null, $criteria)
                    ->filterByDomain($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collMenusPartial && count($collMenus)) {
                        $this->initMenus(false);

                        foreach ($collMenus as $obj) {
                            if (false == $this->collMenus->contains($obj)) {
                                $this->collMenus->append($obj);
                            }
                        }

                        $this->collMenusPartial = true;
                    }

                    return $collMenus;
                }

                if ($partial && $this->collMenus) {
                    foreach ($this->collMenus as $obj) {
                        if ($obj->isNew()) {
                            $collMenus[] = $obj;
                        }
                    }
                }

                $this->collMenus = $collMenus;
                $this->collMenusPartial = false;
            }
        }

        return $this->collMenus;
    }

    /**
     * Sets a collection of Menu objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $menus A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setMenus(Collection $menus, ?ConnectionInterface $con = null)
    {
        /** @var Menu[] $menusToDelete */
        $menusToDelete = $this->getMenus(new Criteria(), $con)->diff($menus);


        $this->menusScheduledForDeletion = $menusToDelete;

        foreach ($menusToDelete as $menuRemoved) {
            $menuRemoved->setDomain(null);
        }

        $this->collMenus = null;
        foreach ($menus as $menu) {
            $this->addMenu($menu);
        }

        $this->collMenus = $menus;
        $this->collMenusPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseMenu objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseMenu objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countMenus(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collMenusPartial && !$this->isNew();
        if (null === $this->collMenus || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collMenus) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getMenus());
            }

            $query = MenuQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByDomain($this)
                ->count($con);
        }

        return count($this->collMenus);
    }

    /**
     * Method called to associate a Menu object to this object
     * through the Menu foreign key attribute.
     *
     * @param Menu $l Menu
     * @return $this The current object (for fluent API support)
     */
    public function addMenu(Menu $l)
    {
        if ($this->collMenus === null) {
            $this->initMenus();
            $this->collMenusPartial = true;
        }

        if (!$this->collMenus->contains($l)) {
            $this->doAddMenu($l);

            if ($this->menusScheduledForDeletion and $this->menusScheduledForDeletion->contains($l)) {
                $this->menusScheduledForDeletion->remove($this->menusScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Menu $menu The Menu object to add.
     */
    protected function doAddMenu(Menu $menu): void
    {
        $this->collMenus[]= $menu;
        $menu->setDomain($this);
    }

    /**
     * @param Menu $menu The Menu object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeMenu(Menu $menu)
    {
        if ($this->getMenus()->contains($menu)) {
            $pos = $this->collMenus->search($menu);
            $this->collMenus->remove($pos);
            if (null === $this->menusScheduledForDeletion) {
                $this->menusScheduledForDeletion = clone $this->collMenus;
                $this->menusScheduledForDeletion->clear();
            }
            $this->menusScheduledForDeletion[]= clone $menu;
            $menu->setDomain(null);
        }

        return $this;
    }

    /**
     * Clears out the collPages collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addPages()
     */
    public function clearPages()
    {
        $this->collPages = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collPages collection loaded partially.
     *
     * @return void
     */
    public function resetPartialPages($v = true): void
    {
        $this->collPagesPartial = $v;
    }

    /**
     * Initializes the collPages collection.
     *
     * By default this just sets the collPages collection to an empty array (like clearcollPages());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPages(bool $overrideExisting = true): void
    {
        if (null !== $this->collPages && !$overrideExisting) {
            return;
        }

        $collectionClassName = PageTableMap::getTableMap()->getCollectionClassName();

        $this->collPages = new $collectionClassName;
        $this->collPages->setModel('\Diamond\Infrastructure\Models\Page\Page');
    }

    /**
     * Gets an array of Page objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildDomain is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Page[] List of Page objects
     * @phpstan-return ObjectCollection&\Traversable<Page> List of Page objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getPages(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collPagesPartial && !$this->isNew();
        if (null === $this->collPages || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collPages) {
                    $this->initPages();
                } else {
                    $collectionClassName = PageTableMap::getTableMap()->getCollectionClassName();

                    $collPages = new $collectionClassName;
                    $collPages->setModel('\Diamond\Infrastructure\Models\Page\Page');

                    return $collPages;
                }
            } else {
                $collPages = PageQuery::create(null, $criteria)
                    ->filterByDomain($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collPagesPartial && count($collPages)) {
                        $this->initPages(false);

                        foreach ($collPages as $obj) {
                            if (false == $this->collPages->contains($obj)) {
                                $this->collPages->append($obj);
                            }
                        }

                        $this->collPagesPartial = true;
                    }

                    return $collPages;
                }

                if ($partial && $this->collPages) {
                    foreach ($this->collPages as $obj) {
                        if ($obj->isNew()) {
                            $collPages[] = $obj;
                        }
                    }
                }

                $this->collPages = $collPages;
                $this->collPagesPartial = false;
            }
        }

        return $this->collPages;
    }

    /**
     * Sets a collection of Page objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $pages A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setPages(Collection $pages, ?ConnectionInterface $con = null)
    {
        /** @var Page[] $pagesToDelete */
        $pagesToDelete = $this->getPages(new Criteria(), $con)->diff($pages);


        $this->pagesScheduledForDeletion = $pagesToDelete;

        foreach ($pagesToDelete as $pageRemoved) {
            $pageRemoved->setDomain(null);
        }

        $this->collPages = null;
        foreach ($pages as $page) {
            $this->addPage($page);
        }

        $this->collPages = $pages;
        $this->collPagesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BasePage objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BasePage objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countPages(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collPagesPartial && !$this->isNew();
        if (null === $this->collPages || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPages) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getPages());
            }

            $query = PageQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByDomain($this)
                ->count($con);
        }

        return count($this->collPages);
    }

    /**
     * Method called to associate a Page object to this object
     * through the Page foreign key attribute.
     *
     * @param Page $l Page
     * @return $this The current object (for fluent API support)
     */
    public function addPage(Page $l)
    {
        if ($this->collPages === null) {
            $this->initPages();
            $this->collPagesPartial = true;
        }

        if (!$this->collPages->contains($l)) {
            $this->doAddPage($l);

            if ($this->pagesScheduledForDeletion and $this->pagesScheduledForDeletion->contains($l)) {
                $this->pagesScheduledForDeletion->remove($this->pagesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Page $page The Page object to add.
     */
    protected function doAddPage(Page $page): void
    {
        $this->collPages[]= $page;
        $page->setDomain($this);
    }

    /**
     * @param Page $page The Page object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removePage(Page $page)
    {
        if ($this->getPages()->contains($page)) {
            $pos = $this->collPages->search($page);
            $this->collPages->remove($pos);
            if (null === $this->pagesScheduledForDeletion) {
                $this->pagesScheduledForDeletion = clone $this->collPages;
                $this->pagesScheduledForDeletion->clear();
            }
            $this->pagesScheduledForDeletion[]= clone $page;
            $page->setDomain(null);
        }

        return $this;
    }

    /**
     * Clears out the collPromoblocks collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addPromoblocks()
     */
    public function clearPromoblocks()
    {
        $this->collPromoblocks = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collPromoblocks collection loaded partially.
     *
     * @return void
     */
    public function resetPartialPromoblocks($v = true): void
    {
        $this->collPromoblocksPartial = $v;
    }

    /**
     * Initializes the collPromoblocks collection.
     *
     * By default this just sets the collPromoblocks collection to an empty array (like clearcollPromoblocks());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initPromoblocks(bool $overrideExisting = true): void
    {
        if (null !== $this->collPromoblocks && !$overrideExisting) {
            return;
        }

        $collectionClassName = PromoblockTableMap::getTableMap()->getCollectionClassName();

        $this->collPromoblocks = new $collectionClassName;
        $this->collPromoblocks->setModel('\Diamond\Infrastructure\Models\Promoblock\Promoblock');
    }

    /**
     * Gets an array of Promoblock objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildDomain is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Promoblock[] List of Promoblock objects
     * @phpstan-return ObjectCollection&\Traversable<Promoblock> List of Promoblock objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getPromoblocks(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collPromoblocksPartial && !$this->isNew();
        if (null === $this->collPromoblocks || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collPromoblocks) {
                    $this->initPromoblocks();
                } else {
                    $collectionClassName = PromoblockTableMap::getTableMap()->getCollectionClassName();

                    $collPromoblocks = new $collectionClassName;
                    $collPromoblocks->setModel('\Diamond\Infrastructure\Models\Promoblock\Promoblock');

                    return $collPromoblocks;
                }
            } else {
                $collPromoblocks = PromoblockQuery::create(null, $criteria)
                    ->filterByDomain($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collPromoblocksPartial && count($collPromoblocks)) {
                        $this->initPromoblocks(false);

                        foreach ($collPromoblocks as $obj) {
                            if (false == $this->collPromoblocks->contains($obj)) {
                                $this->collPromoblocks->append($obj);
                            }
                        }

                        $this->collPromoblocksPartial = true;
                    }

                    return $collPromoblocks;
                }

                if ($partial && $this->collPromoblocks) {
                    foreach ($this->collPromoblocks as $obj) {
                        if ($obj->isNew()) {
                            $collPromoblocks[] = $obj;
                        }
                    }
                }

                $this->collPromoblocks = $collPromoblocks;
                $this->collPromoblocksPartial = false;
            }
        }

        return $this->collPromoblocks;
    }

    /**
     * Sets a collection of Promoblock objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $promoblocks A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setPromoblocks(Collection $promoblocks, ?ConnectionInterface $con = null)
    {
        /** @var Promoblock[] $promoblocksToDelete */
        $promoblocksToDelete = $this->getPromoblocks(new Criteria(), $con)->diff($promoblocks);


        $this->promoblocksScheduledForDeletion = $promoblocksToDelete;

        foreach ($promoblocksToDelete as $promoblockRemoved) {
            $promoblockRemoved->setDomain(null);
        }

        $this->collPromoblocks = null;
        foreach ($promoblocks as $promoblock) {
            $this->addPromoblock($promoblock);
        }

        $this->collPromoblocks = $promoblocks;
        $this->collPromoblocksPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BasePromoblock objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BasePromoblock objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countPromoblocks(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collPromoblocksPartial && !$this->isNew();
        if (null === $this->collPromoblocks || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collPromoblocks) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getPromoblocks());
            }

            $query = PromoblockQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByDomain($this)
                ->count($con);
        }

        return count($this->collPromoblocks);
    }

    /**
     * Method called to associate a Promoblock object to this object
     * through the Promoblock foreign key attribute.
     *
     * @param Promoblock $l Promoblock
     * @return $this The current object (for fluent API support)
     */
    public function addPromoblock(Promoblock $l)
    {
        if ($this->collPromoblocks === null) {
            $this->initPromoblocks();
            $this->collPromoblocksPartial = true;
        }

        if (!$this->collPromoblocks->contains($l)) {
            $this->doAddPromoblock($l);

            if ($this->promoblocksScheduledForDeletion and $this->promoblocksScheduledForDeletion->contains($l)) {
                $this->promoblocksScheduledForDeletion->remove($this->promoblocksScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Promoblock $promoblock The Promoblock object to add.
     */
    protected function doAddPromoblock(Promoblock $promoblock): void
    {
        $this->collPromoblocks[]= $promoblock;
        $promoblock->setDomain($this);
    }

    /**
     * @param Promoblock $promoblock The Promoblock object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removePromoblock(Promoblock $promoblock)
    {
        if ($this->getPromoblocks()->contains($promoblock)) {
            $pos = $this->collPromoblocks->search($promoblock);
            $this->collPromoblocks->remove($pos);
            if (null === $this->promoblocksScheduledForDeletion) {
                $this->promoblocksScheduledForDeletion = clone $this->collPromoblocks;
                $this->promoblocksScheduledForDeletion->clear();
            }
            $this->promoblocksScheduledForDeletion[]= clone $promoblock;
            $promoblock->setDomain(null);
        }

        return $this;
    }

    /**
     * Clears out the collTemplates collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addTemplates()
     */
    public function clearTemplates()
    {
        $this->collTemplates = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collTemplates collection loaded partially.
     *
     * @return void
     */
    public function resetPartialTemplates($v = true): void
    {
        $this->collTemplatesPartial = $v;
    }

    /**
     * Initializes the collTemplates collection.
     *
     * By default this just sets the collTemplates collection to an empty array (like clearcollTemplates());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initTemplates(bool $overrideExisting = true): void
    {
        if (null !== $this->collTemplates && !$overrideExisting) {
            return;
        }

        $collectionClassName = TemplateTableMap::getTableMap()->getCollectionClassName();

        $this->collTemplates = new $collectionClassName;
        $this->collTemplates->setModel('\Diamond\Infrastructure\Models\Template\Template');
    }

    /**
     * Gets an array of Template objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildDomain is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Template[] List of Template objects
     * @phpstan-return ObjectCollection&\Traversable<Template> List of Template objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getTemplates(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collTemplatesPartial && !$this->isNew();
        if (null === $this->collTemplates || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collTemplates) {
                    $this->initTemplates();
                } else {
                    $collectionClassName = TemplateTableMap::getTableMap()->getCollectionClassName();

                    $collTemplates = new $collectionClassName;
                    $collTemplates->setModel('\Diamond\Infrastructure\Models\Template\Template');

                    return $collTemplates;
                }
            } else {
                $collTemplates = TemplateQuery::create(null, $criteria)
                    ->filterByDomain($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collTemplatesPartial && count($collTemplates)) {
                        $this->initTemplates(false);

                        foreach ($collTemplates as $obj) {
                            if (false == $this->collTemplates->contains($obj)) {
                                $this->collTemplates->append($obj);
                            }
                        }

                        $this->collTemplatesPartial = true;
                    }

                    return $collTemplates;
                }

                if ($partial && $this->collTemplates) {
                    foreach ($this->collTemplates as $obj) {
                        if ($obj->isNew()) {
                            $collTemplates[] = $obj;
                        }
                    }
                }

                $this->collTemplates = $collTemplates;
                $this->collTemplatesPartial = false;
            }
        }

        return $this->collTemplates;
    }

    /**
     * Sets a collection of Template objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $templates A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setTemplates(Collection $templates, ?ConnectionInterface $con = null)
    {
        /** @var Template[] $templatesToDelete */
        $templatesToDelete = $this->getTemplates(new Criteria(), $con)->diff($templates);


        $this->templatesScheduledForDeletion = $templatesToDelete;

        foreach ($templatesToDelete as $templateRemoved) {
            $templateRemoved->setDomain(null);
        }

        $this->collTemplates = null;
        foreach ($templates as $template) {
            $this->addTemplate($template);
        }

        $this->collTemplates = $templates;
        $this->collTemplatesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseTemplate objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseTemplate objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countTemplates(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collTemplatesPartial && !$this->isNew();
        if (null === $this->collTemplates || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collTemplates) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getTemplates());
            }

            $query = TemplateQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByDomain($this)
                ->count($con);
        }

        return count($this->collTemplates);
    }

    /**
     * Method called to associate a Template object to this object
     * through the Template foreign key attribute.
     *
     * @param Template $l Template
     * @return $this The current object (for fluent API support)
     */
    public function addTemplate(Template $l)
    {
        if ($this->collTemplates === null) {
            $this->initTemplates();
            $this->collTemplatesPartial = true;
        }

        if (!$this->collTemplates->contains($l)) {
            $this->doAddTemplate($l);

            if ($this->templatesScheduledForDeletion and $this->templatesScheduledForDeletion->contains($l)) {
                $this->templatesScheduledForDeletion->remove($this->templatesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Template $template The Template object to add.
     */
    protected function doAddTemplate(Template $template): void
    {
        $this->collTemplates[]= $template;
        $template->setDomain($this);
    }

    /**
     * @param Template $template The Template object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeTemplate(Template $template)
    {
        if ($this->getTemplates()->contains($template)) {
            $pos = $this->collTemplates->search($template);
            $this->collTemplates->remove($pos);
            if (null === $this->templatesScheduledForDeletion) {
                $this->templatesScheduledForDeletion = clone $this->collTemplates;
                $this->templatesScheduledForDeletion->clear();
            }
            $this->templatesScheduledForDeletion[]= clone $template;
            $template->setDomain(null);
        }

        return $this;
    }

    /**
     * Clears out the collImageSliders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addImageSliders()
     */
    public function clearImageSliders()
    {
        $this->collImageSliders = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collImageSliders collection loaded partially.
     *
     * @return void
     */
    public function resetPartialImageSliders($v = true): void
    {
        $this->collImageSlidersPartial = $v;
    }

    /**
     * Initializes the collImageSliders collection.
     *
     * By default this just sets the collImageSliders collection to an empty array (like clearcollImageSliders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initImageSliders(bool $overrideExisting = true): void
    {
        if (null !== $this->collImageSliders && !$overrideExisting) {
            return;
        }

        $collectionClassName = ImageSliderTableMap::getTableMap()->getCollectionClassName();

        $this->collImageSliders = new $collectionClassName;
        $this->collImageSliders->setModel('\Diamond\Infrastructure\Models\ImageSlider\ImageSlider');
    }

    /**
     * Gets an array of ImageSlider objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildDomain is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|ImageSlider[] List of ImageSlider objects
     * @phpstan-return ObjectCollection&\Traversable<ImageSlider> List of ImageSlider objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getImageSliders(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collImageSlidersPartial && !$this->isNew();
        if (null === $this->collImageSliders || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collImageSliders) {
                    $this->initImageSliders();
                } else {
                    $collectionClassName = ImageSliderTableMap::getTableMap()->getCollectionClassName();

                    $collImageSliders = new $collectionClassName;
                    $collImageSliders->setModel('\Diamond\Infrastructure\Models\ImageSlider\ImageSlider');

                    return $collImageSliders;
                }
            } else {
                $collImageSliders = ImageSliderQuery::create(null, $criteria)
                    ->filterByDomain($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collImageSlidersPartial && count($collImageSliders)) {
                        $this->initImageSliders(false);

                        foreach ($collImageSliders as $obj) {
                            if (false == $this->collImageSliders->contains($obj)) {
                                $this->collImageSliders->append($obj);
                            }
                        }

                        $this->collImageSlidersPartial = true;
                    }

                    return $collImageSliders;
                }

                if ($partial && $this->collImageSliders) {
                    foreach ($this->collImageSliders as $obj) {
                        if ($obj->isNew()) {
                            $collImageSliders[] = $obj;
                        }
                    }
                }

                $this->collImageSliders = $collImageSliders;
                $this->collImageSlidersPartial = false;
            }
        }

        return $this->collImageSliders;
    }

    /**
     * Sets a collection of ImageSlider objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $imageSliders A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setImageSliders(Collection $imageSliders, ?ConnectionInterface $con = null)
    {
        /** @var ImageSlider[] $imageSlidersToDelete */
        $imageSlidersToDelete = $this->getImageSliders(new Criteria(), $con)->diff($imageSliders);


        $this->imageSlidersScheduledForDeletion = $imageSlidersToDelete;

        foreach ($imageSlidersToDelete as $imageSliderRemoved) {
            $imageSliderRemoved->setDomain(null);
        }

        $this->collImageSliders = null;
        foreach ($imageSliders as $imageSlider) {
            $this->addImageSlider($imageSlider);
        }

        $this->collImageSliders = $imageSliders;
        $this->collImageSlidersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseImageSlider objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseImageSlider objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countImageSliders(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collImageSlidersPartial && !$this->isNew();
        if (null === $this->collImageSliders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collImageSliders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getImageSliders());
            }

            $query = ImageSliderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByDomain($this)
                ->count($con);
        }

        return count($this->collImageSliders);
    }

    /**
     * Method called to associate a ImageSlider object to this object
     * through the ImageSlider foreign key attribute.
     *
     * @param ImageSlider $l ImageSlider
     * @return $this The current object (for fluent API support)
     */
    public function addImageSlider(ImageSlider $l)
    {
        if ($this->collImageSliders === null) {
            $this->initImageSliders();
            $this->collImageSlidersPartial = true;
        }

        if (!$this->collImageSliders->contains($l)) {
            $this->doAddImageSlider($l);

            if ($this->imageSlidersScheduledForDeletion and $this->imageSlidersScheduledForDeletion->contains($l)) {
                $this->imageSlidersScheduledForDeletion->remove($this->imageSlidersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ImageSlider $imageSlider The ImageSlider object to add.
     */
    protected function doAddImageSlider(ImageSlider $imageSlider): void
    {
        $this->collImageSliders[]= $imageSlider;
        $imageSlider->setDomain($this);
    }

    /**
     * @param ImageSlider $imageSlider The ImageSlider object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeImageSlider(ImageSlider $imageSlider)
    {
        if ($this->getImageSliders()->contains($imageSlider)) {
            $pos = $this->collImageSliders->search($imageSlider);
            $this->collImageSliders->remove($pos);
            if (null === $this->imageSlidersScheduledForDeletion) {
                $this->imageSlidersScheduledForDeletion = clone $this->collImageSliders;
                $this->imageSlidersScheduledForDeletion->clear();
            }
            $this->imageSlidersScheduledForDeletion[]= $imageSlider;
            $imageSlider->setDomain(null);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        $this->id = null;
        $this->name = null;
        $this->lang = null;
        $this->domain = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
            if ($this->collMenus) {
                foreach ($this->collMenus as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPages) {
                foreach ($this->collPages as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collPromoblocks) {
                foreach ($this->collPromoblocks as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collTemplates) {
                foreach ($this->collTemplates as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collImageSliders) {
                foreach ($this->collImageSliders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collMenus = null;
        $this->collPages = null;
        $this->collPromoblocks = null;
        $this->collTemplates = null;
        $this->collImageSliders = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(DomainTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
