<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 14:51
 */

namespace Diamond\Domain\Site;


use Core\Repository\DropDownInterface;
use Diamond\Domain\Site\Contracts\SiteEntityInterface;
use Repo\Concrete\AbstractCollection;

class SiteCollection extends AbstractCollection implements DropDownInterface
{
    protected function getEntityClass(): string
    {
        return SiteEntityInterface::class;
    }

    public function getDropdownList():array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }
        return $ar;
    }
}