<?php

namespace Diamond\Domain\Menu\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface MenuCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @return bool
     */
    public function asTreeView(): bool;

    public function getSearchByName(): ?string;

    public function getSearchByTitle(): ?string;

    public function getSearchByUrl(): ?string;

    public function getFilterByActive():?bool ;

    public function getFilterByParentId(): ?int;

    public function setFilterByParentId(?int $filterByParentId): MenuCriteriaInterface;
}