<?php

namespace Diamond\Domain\GuestBookItem\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface GuestBookItemCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    public function getSortByDate(): ?string;

    public function setSortByDate(?string $sortByDate): GuestBookItemCriteriaInterface;

    /**
     * @return int|null
     */
    public function getFilterByBookId(): ?int;

    /**
     * @return int|null
     */
    public function getFilterByRank(): ?int;

    /**
     * @return bool|null
     */
    public function getFilterByPublished(): ?bool;

    /**
     * @return string|null
     */
    public function getSearchByUserName(): ?string ;

    /**
     * @return string|null
     */
    public function getSearchByUserEmail(): ?string ;

    /**
     * @return string|null
     */
    public function getFilterByDate(): ?string;

    /**
     * @param int|null $
     * @return mixed
     */
    public function setFilterByObjectId(?int $id);

}