<?php declare(strict_types=1);

namespace Diamond\Application\Mailing;

abstract class RecipientsHandlerAbstract
{

    public function getDataFromEmail(string $email): array
    {
        return [];
    }

    public function getVariables(): array
    {
        //базовые настройки переменных
        return [
            'site' => 'адрес сайта',
            'email' => 'элетронная почта',
            'signature' => 'подпись отправителя',
            'copyright' => 'копирайт',
            'date_short' => 'короткая дата',
            'date' => 'дата',
        ];
    }

    /**
     * Извлекает список email из строки
     * @param string $string
     * @return array
     */
    protected function extractEmails(string $string): array
    {
        // Приводим к единому разделителю
        $string = preg_replace('/[\n\r\t;|]+/', ',', $string);

        // Удаляем лишние пробелы
        $string = preg_replace('/\s*,\s*/', ',', $string);
        $string = trim($string, " ,\t\n\r\0\x0B");

        // Разбиваем
        $parts = explode(',', $string);

        // Фильтруем валидные email
        $emails = [];
        foreach ($parts as $part) {
            $email = trim($part);
            if (!empty($email) && filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $emails[] = $email;
            }
        }

        return array_unique($emails);
    }

}