<?php


namespace Diamond\Application\Imaging;


use Diamond\Config\Content;
use Diamond\Domain\SliderImage\SliderImageCollection;
use Diamond\Repositories\SliderImage\SliderImageCriteria;
use Diamond\Repositories\SliderImage\SliderImageRepository;

class ImagingService
{

    protected $contentConfig;
    protected $imageSliderRepository;

    /**
     * Imaging constructor.
     * @param Content $contentConfig
     */
    public function __construct(Content $contentConfig, SliderImageRepository $imageRepository)
    {
        $this->contentConfig = $contentConfig;
        $this->imageSliderRepository = $imageRepository;
    }

    /**
     * Путь к иубличной директории
     * @param bool $realative
     * @return string
     */
    public function getUploadDir(bool $realative = true): string
    {
        return $realative === true ? BASEPATH . '/public_html/upload' : '/upload';
    }

    /**
     * кеш каталог
     * @return string
     */
    public function getCacheDir(): string
    {
        return BASEPATH . '/app/cache';
    }

    /**
     * @return string
     */
    public function getPublicUploadDir(): string
    {
        return '/upload';
    }

    /**
     * @return string
     */
    public function getSliderImageDir(): string
    {
        return $this->getUploadDir() . $this->contentConfig->getSliderImagesPath();
    }

    /**
     * @return string
     */
    public function getPublicSliderImageDir(): string
    {
        return '/upload/' . ltrim($this->contentConfig->getSliderImagesPath(), '/');
    }

    /**
     * @param int $siteId
     * @return SliderImageCollection
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function getSliderImagesForSite(int $siteId): SliderImageCollection
    {
        $images = $this->imageSliderRepository->findByCriteria(
            SliderImageCriteria::create()
                ->setFilterBySiteId($siteId)
                ->setFilterByActive(true)
        );

        return $images;
    }
}