<?php


namespace Diamond\Application\Content\Exceptions;

use Core\Exceptions\BaseException;

class PageNotFoundException extends BaseException
{
    protected $url;

    /**
     * PageNotFound constructor.
     * @param string $url
     */
    public function __construct(string $url)
    {
        parent::__construct(sprintf('Page %s not found', $url));
    }

    /**
     * @return string
     */
    public function getUrl():string
    {
        return $this->url;
    }
}