<?php
namespace Diamond;

use Core\Application\Loader;
use Diamond\Application\Mailing\RecipientsHandlerAbstract;
use Diamond\Application\Mailing\RecipientsHandlerInterface;
use Diamond\Repositories\User\UserCriteria;
use Diamond\Repositories\User\UserRepository;

class UserRecipients extends RecipientsHandlerAbstract implements RecipientsHandlerInterface
{

    private const VAR_NAME = 'user_name';

    public function __construct(protected UserRepository $userRepository)
    {
    }

    public function getName(): string
    {
        return 'Система / Все пользователи';
    }

    public function getMails(): array
    {
        $di = Loader::getInstance()->load('DI');
        /** @var UserRepository $userRepository */
        $userRepository = $di->get(UserRepository::class);

        $userCollection = $userRepository->findByCriteria(UserCriteria::create());

        $emails = [];

        foreach ($userCollection as $user){
            $emails[] = $user->getEmail();
        }

        return $emails;
    }

    public function getDataFromEmail(string $email): array
    {
        //в получении инфы по email не используем доп фильтры так как цель получить данные
        $user = $this->userRepository->findByCriteria(
            UserCriteria::create()->setFilterByEmail($email)
        )->current();

        if (!empty($user)) {
            return [
                static::VAR_NAME => $user->getName(),
            ];
        }

        return [];
    }

    public function getVariables(): array
    {

        return array_merge(parent::getVariables(), [
            static::VAR_NAME => 'Имя пользователя'
        ]);
    }

}