<?php

namespace Diamond\Modules\MailingDemo;


use Diamond\Application\Mailing\MailingService;
use Diamond\Application\Mailing\Exceptions\MailingListNotFoundException;

/**
 * Description of MailingListDemo
 *
 * @author Diamond Code Generator
 */
class MailingDemo extends \Core\ModuleController
{

//    protected $mailingRepo;
//    protected $mailingService;
//
//    public function __construct(
//        \Diamond\Repositories\Mailing $mailingRepo,
//        \Diamond\Services\Mailing $mailingService
//    )
//    {
//        $this->mailingService = $mailingService;
//        $this->mailingRepo = $mailingRepo;
//    }

    private $mailingUseCase;

    public function __construct(MailingService $mailingUseCase)
    {
        $this->mailingUseCase = $mailingUseCase;
    }

    /**
     * @return string
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\SyntaxError
     */
    public function process():string
    {
        if (!$id = input_get('id')) {
            throw new \Core\Exceptions\NoAccess();
        }

        //получение рассылки по id
        try{
            $mailing = $this->mailingUseCase->getMailingList($id);
        }
        catch (MailingListNotFoundException $ex){
            return 'Рассылка не найдена';
        }

        //формирование содержимого письма для подписчика
        $body = $this->mailingUseCase->getMailingListBodyForSubscriber($mailing);

        return $body;
    }
}               