<?php

namespace Diamond\Helpers;

/**
 * Хелпер для работы с датой
 *
 * @see \Core\Helpers\Date
 * @author Admin
 */
class Date extends \Core\Helpers\Date
{

    /**
     * строит диапазон дат для контроллеров статистики
     * @param int $limit
     * @param int $li
     * @param bool $nextDay
     * @return array
     */
    public static function getDefaultDates(int $limit, int $li = 24, bool $nextDay = false): array
    {

        $dates = [];
        $startDate = strtotime(date('Y-m-d', strtotime(sprintf('-%s day', $limit))));

        if($nextDay===false){
            $endDate = (new \DateTime())->getTimestamp();
        }
        else{
            $endDate = (new \DateTime('+1 day'))->getTimestamp();
        }

        $period = $li * 60 * 60;
        for ($i = $startDate; $i <= $endDate; $i += $period) {

            if($li===24){
                $d = date('d.m.Y 00:00', $i);
                $key = strtotime($d);
            }
            else{
                $d = date('d.m.Y H:i', $i);
                $key = $i;
            }


            $dates[$key] = array(
                $i * 1000,
                0,
                $d
            );
        }

        return $dates;
    }

}