<?php


namespace Diamond\Factory;


use Monolog\Handler\StreamHandler;
use Psr\Log\LoggerInterface;

class Logger
{
    /**
     * СОздание логгера для хранения в файле
     * @param $levels
     * @param $name
     * @param string $fileName
     * @param string $dateformat
     * @param string $format
     * @return LoggerInterface
     * @throws \Exception
     */
    public static function buildFileLogger($levels,
                                           $name,
                                           $fileName = "debug",
                                           $dateformat = "m_d_y",
                                           $format = "[%datetime%] [%level_name%] %message% [Context %context% Extra %extra%]\n"
    ): LoggerInterface
    {

        $logger = (new \Monolog\Logger($name));

        if (!is_array($levels)) {
            $levels = (array)$levels;
        }

        foreach ($levels as $level) {

            $stream = new StreamHandler(sprintf(
                BASEPATH . '/app/logs/' . $fileName . '_%s.log', date($dateformat)
            ), $level);
            $stream->setFormatter(new \Monolog\Formatter\LineFormatter($format, 'd/m/Y H:i:s'));

            $logger->pushHandler($stream);
        }

        return $logger;
    }
}