<?php
namespace Diamond\Repositories;

use Core\Repository\CrudInterface;
use Core\Repository\PropelQueryAbstract;
use Diamond\Infrastructure\Models\UserGroup\UserGroup as Group;
use Diamond\Infrastructure\Models\UserGroup\UserGroupQuery;

/**
 * Description of Bonus
 *
 * @author Dmitriy
 */
class UserGroup extends PropelQueryAbstract implements CrudInterface, \Core\Repository\DropDownInterface{
    
    public function buildEntity() {
        return new Group();
    }

    public function buildQuery() {
        return UserGroupQuery::create();
    }

    public function getDropdownList():array{
	return $this->buildQuery()
		->orderByName()
		->find()
		->toKeyValue('id','name');
    } 
    
    /**
     * Список прав доступа без админа
     * @return type
     */
    public function getDropdownListWhitoutRoot(){
	return $this->buildQuery()
		->orderByName()
                ->filterByGrpCode("root", \Propel\Runtime\ActiveQuery\Criteria::ALT_NOT_EQUAL)
		->find()
		->toKeyValue('id','name');
    }        
}
