<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:25
 */

namespace Diamond\Repositories\Page;


use Diamond\Domain\Page\Contracts\PageCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class PageCriteria extends AbstractCriteria implements PageCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByCode;
    /**
     * @var string|null
     */
    protected $searchByTitle;
    /**
     * @var string|null
     */
    protected $searchByUrl;

    /**
     * @var string|null
     */
    protected $searchByScript;

    /**
     * @var string|null
     */
    protected $filterByTemplate;

    /**
     * @var bool|null
     */
    protected $filterBySystem;

    /**
     * @var bool|null
     */
    protected $filterByActive;


    /**
     * @var int|null
     */
    protected $filterBySiteId;

    public static function create()
    {
        return new self;
    }

    public function getSearchByCode(): ?string
    {
        return $this->searchByCode;
    }

    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    public function getSearchByUrl(): ?string
    {
        return $this->searchByUrl;
    }

    public function getSearchByScript(): ?string
    {
        return $this->searchByScript;
    }

    public function getFilterByTemplate(): ?string
    {
        return $this->filterByTemplate;
    }

    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    public function getFilterBySystem(): ?bool
    {
        return $this->filterBySystem;
    }

    /**
     * @param string|null $searchByCode
     * @return PageCriteria
     */
    public function setSearchByCode(?string $searchByCode): PageCriteria
    {
        $this->searchByCode = $searchByCode;
        return $this;
    }

    /**
     * @param string|null $searchByTitle
     * @return PageCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): PageCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }

    /**
     * @param string|null $searchByUrl
     * @return PageCriteria
     */
    public function setSearchByUrl(?string $searchByUrl): PageCriteria
    {
        $this->searchByUrl = $searchByUrl;
        return $this;
    }

    /**
     * @param string|null $searchByScript
     * @return PageCriteria
     */
    public function setSearchByScript(?string $searchByScript): PageCriteria
    {
        $this->searchByScript = $searchByScript;
        return $this;
    }

    /**
     * @param string|null $filterByTemplate
     * @return PageCriteria
     */
    public function setFilterByTemplate(?string $filterByTemplate): PageCriteria
    {
        $this->filterByTemplate = $filterByTemplate;
        return $this;
    }

    /**
     * @param bool|null $filterBySystem
     * @return PageCriteria
     */
    public function setFilterBySystem(?bool $filterBySystem): PageCriteria
    {
        $this->filterBySystem = $filterBySystem;
        return $this;
    }

    /**
     * @param bool|null $filterByActive
     * @return PageCriteria
     */
    public function setFilterByActive(?bool $filterByActive): PageCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterBySiteId(): ?int
    {
        return $this->filterBySiteId;
    }

    /**
     * @param int|null $filterBySiteId
     * @return PageCriteria
     */
    public function setFilterBySiteId(?int $filterBySiteId): PageCriteria
    {
        $this->filterBySiteId = $filterBySiteId;
        return $this;
    }


}