<?php

namespace Diamond\Repositories\MailingList;


use Diamond\Domain\MailingList\Concrete\MailingListCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MailingListCriteria extends AbstractCriteria implements MailingListCriteriaInterface
{
    /**
     * @var bool
     */
    protected bool|null $filterByActive = null;

    public static function create()
    {
        return new self();
    }

    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool $filterByActive
     * @return MailingListCriteria
     */
    public function setFilterByActive(?bool $filterByActive): MailingListCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }

}