<?php


namespace Diamond\Repositories\ErrorLog;


use Repo\Concrete\AbstractEntity;

class ErrorLogEntity extends AbstractEntity
{

    /**
     * @var int|null
     */
    protected $errors;

    protected $fileName;

    protected $size;

    protected $date;

    protected $pathName;

    /**
     * @return int|null
     */
    public function getErrors(): ?int
    {
        return $this->errors;
    }

    /**
     * @param int|null $errors
     * @return ErrorLogEntity
     */
    public function setErrors(?int $errors): ErrorLogEntity
    {
        $this->errors = $errors;
        return $this;
    }


    /**
     * @return mixed
     */
    public function getPathName(): string
    {
        return $this->pathName;
    }

    /**
     * @param mixed $pathName
     * @return ErrorLogEntity
     */
    public function setPathName(string $pathName)
    {
        $this->pathName = $pathName;
        return $this;
    }


    /**
     * @return mixed
     */
    public function getFileName(): string
    {
        return $this->fileName;
    }

    /**
     * @param mixed $fileName
     * @return ErrorLogEntity
     */
    public function setFileName(string $fileName)
    {
        $this->fileName = $fileName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSize(): int
    {
        return $this->size;
    }

    /**
     * @param mixed $size
     * @return ErrorLogEntity
     */
    public function setSize(int $size)
    {
        $this->size = $size;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getDate(): ?\DateTime
    {
        return $this->date;
    }

    /**
     * @param \DateTime|null $date
     * @return $this
     */
    public function setDate(?\DateTime $date)
    {
        $this->date = $date;
        return $this;
    }


}