<?php

namespace Diamond\Repositories\ContentTag;


use Diamond\Domain\ContentTag\Contracts\ContentTagCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class ContentTagCriteria extends AbstractCriteria implements ContentTagCriteriaInterface
{

    protected string|null $searchByName = null;

    /**
     * @return ContentTagCriteria
     */
    public static function create()
    {
        return new self();
    }

    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    public function setSearchByName(?string $searchByName): ContentTagCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }

}