<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 01.09.2020
 * Time: 0:07
 */

namespace Diamond\Repositories\ContentCategory;


use Diamond\Domain\Content\Contracts\ContentCriteriaInterface;
use Diamond\Domain\ContentCategory\ContentCategoryCollection;
use Diamond\Infrastructure\Models\Content\ContentQuery;
use Diamond\Infrastructure\Models\ContentCategory\ContentCategory;
use Diamond\Infrastructure\Models\ContentCategory\ContentCategoryQuery;
use Diamond\Repositories\CrudRepositoryTrait;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

/**
 * Class ContentCategoryRepository
 * @package Diamond\Repositories\ContentCategory
 */
class ContentCategoryRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    /**
     * @return EntityInterface|ContentCategory
     */
    public static function createEntity(): EntityInterface
    {
        return new ContentCategory();
    }

    /**
     * @return ModelCriteria|ContentCategoryQuery
     */
    protected function createQuery(): ModelCriteria
    {
        return ContentCategoryQuery::create();
    }


    /**
     * @param PaginationInterface|ContentCategoryCriteriaInterface $criteria
     * @return CollectionInterface|ContentCategoryCollection
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    protected function createCollection(): CollectionInterface
    {

        return new ContentCategoryCollection();
    }




    /**
     * @param PaginationInterface|ContentCriteriaInterface $criteria
     * @param ModelCriteria|ContentQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

    }

}