<?php

namespace Diamond\Infrastructure\Models\Page\Map;

use Diamond\Infrastructure\Models\Page\Page;
use Diamond\Infrastructure\Models\Page\PageQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_pages' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class PageTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.Page.Map.PageTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_pages';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\Page\\Page';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.Page.Page';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 20;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 20;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_pages.id';

    /**
     * the column name for the code field
     */
    public const COL_CODE = '_pages.code';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = '_pages.title';

    /**
     * the column name for the url field
     */
    public const COL_URL = '_pages.url';

    /**
     * the column name for the template field
     */
    public const COL_TEMPLATE = '_pages.template';

    /**
     * the column name for the script field
     */
    public const COL_SCRIPT = '_pages.script';

    /**
     * the column name for the content field
     */
    public const COL_CONTENT = '_pages.content';

    /**
     * the column name for the system field
     */
    public const COL_SYSTEM = '_pages.system';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = '_pages.active';

    /**
     * the column name for the module field
     */
    public const COL_MODULE = '_pages.module';

    /**
     * the column name for the module_params field
     */
    public const COL_MODULE_PARAMS = '_pages.module_params';

    /**
     * the column name for the mt_title field
     */
    public const COL_MT_TITLE = '_pages.mt_title';

    /**
     * the column name for the mt_description field
     */
    public const COL_MT_DESCRIPTION = '_pages.mt_description';

    /**
     * the column name for the mt_keywords field
     */
    public const COL_MT_KEYWORDS = '_pages.mt_keywords';

    /**
     * the column name for the mt_robots field
     */
    public const COL_MT_ROBOTS = '_pages.mt_robots';

    /**
     * the column name for the seo_rule field
     */
    public const COL_SEO_RULE = '_pages.seo_rule';

    /**
     * the column name for the pgs_seo_fn field
     */
    public const COL_PGS_SEO_FN = '_pages.pgs_seo_fn';

    /**
     * the column name for the datecreate field
     */
    public const COL_DATECREATE = '_pages.datecreate';

    /**
     * the column name for the dateupdate field
     */
    public const COL_DATEUPDATE = '_pages.dateupdate';

    /**
     * the column name for the domain_id field
     */
    public const COL_DOMAIN_ID = '_pages.domain_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Code', 'Title', 'Url', 'Template', 'Script', 'Content', 'System', 'Active', 'Module', 'ModuleParams', 'MtTitle', 'MtDescription', 'MtKeywords', 'MtRobots', 'SeoRule', 'PgsSeoFn', 'Datecreate', 'DateUpdate', 'DomainId', ],
        self::TYPE_CAMELNAME     => ['id', 'code', 'title', 'url', 'template', 'script', 'content', 'system', 'active', 'module', 'moduleParams', 'mtTitle', 'mtDescription', 'mtKeywords', 'mtRobots', 'seoRule', 'pgsSeoFn', 'datecreate', 'dateUpdate', 'domainId', ],
        self::TYPE_COLNAME       => [PageTableMap::COL_ID, PageTableMap::COL_CODE, PageTableMap::COL_TITLE, PageTableMap::COL_URL, PageTableMap::COL_TEMPLATE, PageTableMap::COL_SCRIPT, PageTableMap::COL_CONTENT, PageTableMap::COL_SYSTEM, PageTableMap::COL_ACTIVE, PageTableMap::COL_MODULE, PageTableMap::COL_MODULE_PARAMS, PageTableMap::COL_MT_TITLE, PageTableMap::COL_MT_DESCRIPTION, PageTableMap::COL_MT_KEYWORDS, PageTableMap::COL_MT_ROBOTS, PageTableMap::COL_SEO_RULE, PageTableMap::COL_PGS_SEO_FN, PageTableMap::COL_DATECREATE, PageTableMap::COL_DATEUPDATE, PageTableMap::COL_DOMAIN_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'code', 'title', 'url', 'template', 'script', 'content', 'system', 'active', 'module', 'module_params', 'mt_title', 'mt_description', 'mt_keywords', 'mt_robots', 'seo_rule', 'pgs_seo_fn', 'datecreate', 'dateupdate', 'domain_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Code' => 1, 'Title' => 2, 'Url' => 3, 'Template' => 4, 'Script' => 5, 'Content' => 6, 'System' => 7, 'Active' => 8, 'Module' => 9, 'ModuleParams' => 10, 'MtTitle' => 11, 'MtDescription' => 12, 'MtKeywords' => 13, 'MtRobots' => 14, 'SeoRule' => 15, 'PgsSeoFn' => 16, 'Datecreate' => 17, 'DateUpdate' => 18, 'DomainId' => 19, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'code' => 1, 'title' => 2, 'url' => 3, 'template' => 4, 'script' => 5, 'content' => 6, 'system' => 7, 'active' => 8, 'module' => 9, 'moduleParams' => 10, 'mtTitle' => 11, 'mtDescription' => 12, 'mtKeywords' => 13, 'mtRobots' => 14, 'seoRule' => 15, 'pgsSeoFn' => 16, 'datecreate' => 17, 'dateUpdate' => 18, 'domainId' => 19, ],
        self::TYPE_COLNAME       => [PageTableMap::COL_ID => 0, PageTableMap::COL_CODE => 1, PageTableMap::COL_TITLE => 2, PageTableMap::COL_URL => 3, PageTableMap::COL_TEMPLATE => 4, PageTableMap::COL_SCRIPT => 5, PageTableMap::COL_CONTENT => 6, PageTableMap::COL_SYSTEM => 7, PageTableMap::COL_ACTIVE => 8, PageTableMap::COL_MODULE => 9, PageTableMap::COL_MODULE_PARAMS => 10, PageTableMap::COL_MT_TITLE => 11, PageTableMap::COL_MT_DESCRIPTION => 12, PageTableMap::COL_MT_KEYWORDS => 13, PageTableMap::COL_MT_ROBOTS => 14, PageTableMap::COL_SEO_RULE => 15, PageTableMap::COL_PGS_SEO_FN => 16, PageTableMap::COL_DATECREATE => 17, PageTableMap::COL_DATEUPDATE => 18, PageTableMap::COL_DOMAIN_ID => 19, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'code' => 1, 'title' => 2, 'url' => 3, 'template' => 4, 'script' => 5, 'content' => 6, 'system' => 7, 'active' => 8, 'module' => 9, 'module_params' => 10, 'mt_title' => 11, 'mt_description' => 12, 'mt_keywords' => 13, 'mt_robots' => 14, 'seo_rule' => 15, 'pgs_seo_fn' => 16, 'datecreate' => 17, 'dateupdate' => 18, 'domain_id' => 19, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Page.Id' => 'ID',
        'id' => 'ID',
        'page.id' => 'ID',
        'PageTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_pages.id' => 'ID',
        'Code' => 'CODE',
        'Page.Code' => 'CODE',
        'code' => 'CODE',
        'page.code' => 'CODE',
        'PageTableMap::COL_CODE' => 'CODE',
        'COL_CODE' => 'CODE',
        '_pages.code' => 'CODE',
        'Title' => 'TITLE',
        'Page.Title' => 'TITLE',
        'title' => 'TITLE',
        'page.title' => 'TITLE',
        'PageTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        '_pages.title' => 'TITLE',
        'Url' => 'URL',
        'Page.Url' => 'URL',
        'url' => 'URL',
        'page.url' => 'URL',
        'PageTableMap::COL_URL' => 'URL',
        'COL_URL' => 'URL',
        '_pages.url' => 'URL',
        'Template' => 'TEMPLATE',
        'Page.Template' => 'TEMPLATE',
        'template' => 'TEMPLATE',
        'page.template' => 'TEMPLATE',
        'PageTableMap::COL_TEMPLATE' => 'TEMPLATE',
        'COL_TEMPLATE' => 'TEMPLATE',
        '_pages.template' => 'TEMPLATE',
        'Script' => 'SCRIPT',
        'Page.Script' => 'SCRIPT',
        'script' => 'SCRIPT',
        'page.script' => 'SCRIPT',
        'PageTableMap::COL_SCRIPT' => 'SCRIPT',
        'COL_SCRIPT' => 'SCRIPT',
        '_pages.script' => 'SCRIPT',
        'Content' => 'CONTENT',
        'Page.Content' => 'CONTENT',
        'content' => 'CONTENT',
        'page.content' => 'CONTENT',
        'PageTableMap::COL_CONTENT' => 'CONTENT',
        'COL_CONTENT' => 'CONTENT',
        '_pages.content' => 'CONTENT',
        'System' => 'SYSTEM',
        'Page.System' => 'SYSTEM',
        'system' => 'SYSTEM',
        'page.system' => 'SYSTEM',
        'PageTableMap::COL_SYSTEM' => 'SYSTEM',
        'COL_SYSTEM' => 'SYSTEM',
        '_pages.system' => 'SYSTEM',
        'Active' => 'ACTIVE',
        'Page.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'page.active' => 'ACTIVE',
        'PageTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        '_pages.active' => 'ACTIVE',
        'Module' => 'MODULE',
        'Page.Module' => 'MODULE',
        'module' => 'MODULE',
        'page.module' => 'MODULE',
        'PageTableMap::COL_MODULE' => 'MODULE',
        'COL_MODULE' => 'MODULE',
        '_pages.module' => 'MODULE',
        'ModuleParams' => 'MODULE_PARAMS',
        'Page.ModuleParams' => 'MODULE_PARAMS',
        'moduleParams' => 'MODULE_PARAMS',
        'page.moduleParams' => 'MODULE_PARAMS',
        'PageTableMap::COL_MODULE_PARAMS' => 'MODULE_PARAMS',
        'COL_MODULE_PARAMS' => 'MODULE_PARAMS',
        'module_params' => 'MODULE_PARAMS',
        '_pages.module_params' => 'MODULE_PARAMS',
        'MtTitle' => 'MT_TITLE',
        'Page.MtTitle' => 'MT_TITLE',
        'mtTitle' => 'MT_TITLE',
        'page.mtTitle' => 'MT_TITLE',
        'PageTableMap::COL_MT_TITLE' => 'MT_TITLE',
        'COL_MT_TITLE' => 'MT_TITLE',
        'mt_title' => 'MT_TITLE',
        '_pages.mt_title' => 'MT_TITLE',
        'MtDescription' => 'MT_DESCRIPTION',
        'Page.MtDescription' => 'MT_DESCRIPTION',
        'mtDescription' => 'MT_DESCRIPTION',
        'page.mtDescription' => 'MT_DESCRIPTION',
        'PageTableMap::COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'mt_description' => 'MT_DESCRIPTION',
        '_pages.mt_description' => 'MT_DESCRIPTION',
        'MtKeywords' => 'MT_KEYWORDS',
        'Page.MtKeywords' => 'MT_KEYWORDS',
        'mtKeywords' => 'MT_KEYWORDS',
        'page.mtKeywords' => 'MT_KEYWORDS',
        'PageTableMap::COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'mt_keywords' => 'MT_KEYWORDS',
        '_pages.mt_keywords' => 'MT_KEYWORDS',
        'MtRobots' => 'MT_ROBOTS',
        'Page.MtRobots' => 'MT_ROBOTS',
        'mtRobots' => 'MT_ROBOTS',
        'page.mtRobots' => 'MT_ROBOTS',
        'PageTableMap::COL_MT_ROBOTS' => 'MT_ROBOTS',
        'COL_MT_ROBOTS' => 'MT_ROBOTS',
        'mt_robots' => 'MT_ROBOTS',
        '_pages.mt_robots' => 'MT_ROBOTS',
        'SeoRule' => 'SEO_RULE',
        'Page.SeoRule' => 'SEO_RULE',
        'seoRule' => 'SEO_RULE',
        'page.seoRule' => 'SEO_RULE',
        'PageTableMap::COL_SEO_RULE' => 'SEO_RULE',
        'COL_SEO_RULE' => 'SEO_RULE',
        'seo_rule' => 'SEO_RULE',
        '_pages.seo_rule' => 'SEO_RULE',
        'PgsSeoFn' => 'PGS_SEO_FN',
        'Page.PgsSeoFn' => 'PGS_SEO_FN',
        'pgsSeoFn' => 'PGS_SEO_FN',
        'page.pgsSeoFn' => 'PGS_SEO_FN',
        'PageTableMap::COL_PGS_SEO_FN' => 'PGS_SEO_FN',
        'COL_PGS_SEO_FN' => 'PGS_SEO_FN',
        'pgs_seo_fn' => 'PGS_SEO_FN',
        '_pages.pgs_seo_fn' => 'PGS_SEO_FN',
        'Datecreate' => 'DATECREATE',
        'Page.Datecreate' => 'DATECREATE',
        'datecreate' => 'DATECREATE',
        'page.datecreate' => 'DATECREATE',
        'PageTableMap::COL_DATECREATE' => 'DATECREATE',
        'COL_DATECREATE' => 'DATECREATE',
        '_pages.datecreate' => 'DATECREATE',
        'DateUpdate' => 'DATEUPDATE',
        'Page.DateUpdate' => 'DATEUPDATE',
        'dateUpdate' => 'DATEUPDATE',
        'page.dateUpdate' => 'DATEUPDATE',
        'PageTableMap::COL_DATEUPDATE' => 'DATEUPDATE',
        'COL_DATEUPDATE' => 'DATEUPDATE',
        'dateupdate' => 'DATEUPDATE',
        '_pages.dateupdate' => 'DATEUPDATE',
        'DomainId' => 'DOMAIN_ID',
        'Page.DomainId' => 'DOMAIN_ID',
        'domainId' => 'DOMAIN_ID',
        'page.domainId' => 'DOMAIN_ID',
        'PageTableMap::COL_DOMAIN_ID' => 'DOMAIN_ID',
        'COL_DOMAIN_ID' => 'DOMAIN_ID',
        'domain_id' => 'DOMAIN_ID',
        '_pages.domain_id' => 'DOMAIN_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_pages');
        $this->setPhpName('Page');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\Page\\Page');
        $this->setPackage('Diamond.Infrastructure.Models.Page');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('code', 'Code', 'VARCHAR', false, 50, null);
        $this->addColumn('title', 'Title', 'VARCHAR', false, 255, null);
        $this->addColumn('url', 'Url', 'VARCHAR', false, 255, null);
        $this->addColumn('template', 'Template', 'CHAR', false, 50, null);
        $this->addColumn('script', 'Script', 'VARCHAR', false, 255, null);
        $this->addColumn('content', 'Content', 'LONGVARCHAR', false, null, null);
        $this->addColumn('system', 'System', 'CHAR', false, null, 'N');
        $this->addColumn('active', 'Active', 'CHAR', false, null, 'Y');
        $this->addColumn('module', 'Module', 'VARCHAR', false, 255, null);
        $this->addColumn('module_params', 'ModuleParams', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_title', 'MtTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('mt_description', 'MtDescription', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_keywords', 'MtKeywords', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_robots', 'MtRobots', 'VARCHAR', false, 10, null);
        $this->addColumn('seo_rule', 'SeoRule', 'VARCHAR', false, 50, null);
        $this->addColumn('pgs_seo_fn', 'PgsSeoFn', 'VARCHAR', false, 50, null);
        $this->addColumn('datecreate', 'Datecreate', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('dateupdate', 'DateUpdate', 'TIMESTAMP', false, null, null);
        $this->addForeignKey('domain_id', 'DomainId', 'INTEGER', '_domains', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Domain', '\\Diamond\\Infrastructure\\Models\\Domain\\Domain', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':domain_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     *
     * Gets the list of behaviors registered for this table
     *
     * @return array<string, array> Associative array (name => parameters) of behaviors
     */
    public function getBehaviors(): array
    {
        return [
            'archivable' => ['archive_table' => '', 'archive_phpname' => NULL, 'archive_class' => '', 'log_archived_at' => 'true', 'archived_at_column' => 'archived_at', 'archive_on_insert' => 'false', 'archive_on_update' => 'false', 'archive_on_delete' => 'true'],
        ];
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? PageTableMap::CLASS_DEFAULT : PageTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Page object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = PageTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = PageTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + PageTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = PageTableMap::OM_CLASS;
            /** @var Page $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            PageTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = PageTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = PageTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Page $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                PageTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(PageTableMap::COL_ID);
            $criteria->addSelectColumn(PageTableMap::COL_CODE);
            $criteria->addSelectColumn(PageTableMap::COL_TITLE);
            $criteria->addSelectColumn(PageTableMap::COL_URL);
            $criteria->addSelectColumn(PageTableMap::COL_TEMPLATE);
            $criteria->addSelectColumn(PageTableMap::COL_SCRIPT);
            $criteria->addSelectColumn(PageTableMap::COL_CONTENT);
            $criteria->addSelectColumn(PageTableMap::COL_SYSTEM);
            $criteria->addSelectColumn(PageTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(PageTableMap::COL_MODULE);
            $criteria->addSelectColumn(PageTableMap::COL_MODULE_PARAMS);
            $criteria->addSelectColumn(PageTableMap::COL_MT_TITLE);
            $criteria->addSelectColumn(PageTableMap::COL_MT_DESCRIPTION);
            $criteria->addSelectColumn(PageTableMap::COL_MT_KEYWORDS);
            $criteria->addSelectColumn(PageTableMap::COL_MT_ROBOTS);
            $criteria->addSelectColumn(PageTableMap::COL_SEO_RULE);
            $criteria->addSelectColumn(PageTableMap::COL_PGS_SEO_FN);
            $criteria->addSelectColumn(PageTableMap::COL_DATECREATE);
            $criteria->addSelectColumn(PageTableMap::COL_DATEUPDATE);
            $criteria->addSelectColumn(PageTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.code');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.url');
            $criteria->addSelectColumn($alias . '.template');
            $criteria->addSelectColumn($alias . '.script');
            $criteria->addSelectColumn($alias . '.content');
            $criteria->addSelectColumn($alias . '.system');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.module');
            $criteria->addSelectColumn($alias . '.module_params');
            $criteria->addSelectColumn($alias . '.mt_title');
            $criteria->addSelectColumn($alias . '.mt_description');
            $criteria->addSelectColumn($alias . '.mt_keywords');
            $criteria->addSelectColumn($alias . '.mt_robots');
            $criteria->addSelectColumn($alias . '.seo_rule');
            $criteria->addSelectColumn($alias . '.pgs_seo_fn');
            $criteria->addSelectColumn($alias . '.datecreate');
            $criteria->addSelectColumn($alias . '.dateupdate');
            $criteria->addSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(PageTableMap::COL_ID);
            $criteria->removeSelectColumn(PageTableMap::COL_CODE);
            $criteria->removeSelectColumn(PageTableMap::COL_TITLE);
            $criteria->removeSelectColumn(PageTableMap::COL_URL);
            $criteria->removeSelectColumn(PageTableMap::COL_TEMPLATE);
            $criteria->removeSelectColumn(PageTableMap::COL_SCRIPT);
            $criteria->removeSelectColumn(PageTableMap::COL_CONTENT);
            $criteria->removeSelectColumn(PageTableMap::COL_SYSTEM);
            $criteria->removeSelectColumn(PageTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(PageTableMap::COL_MODULE);
            $criteria->removeSelectColumn(PageTableMap::COL_MODULE_PARAMS);
            $criteria->removeSelectColumn(PageTableMap::COL_MT_TITLE);
            $criteria->removeSelectColumn(PageTableMap::COL_MT_DESCRIPTION);
            $criteria->removeSelectColumn(PageTableMap::COL_MT_KEYWORDS);
            $criteria->removeSelectColumn(PageTableMap::COL_MT_ROBOTS);
            $criteria->removeSelectColumn(PageTableMap::COL_SEO_RULE);
            $criteria->removeSelectColumn(PageTableMap::COL_PGS_SEO_FN);
            $criteria->removeSelectColumn(PageTableMap::COL_DATECREATE);
            $criteria->removeSelectColumn(PageTableMap::COL_DATEUPDATE);
            $criteria->removeSelectColumn(PageTableMap::COL_DOMAIN_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.code');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.url');
            $criteria->removeSelectColumn($alias . '.template');
            $criteria->removeSelectColumn($alias . '.script');
            $criteria->removeSelectColumn($alias . '.content');
            $criteria->removeSelectColumn($alias . '.system');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.module');
            $criteria->removeSelectColumn($alias . '.module_params');
            $criteria->removeSelectColumn($alias . '.mt_title');
            $criteria->removeSelectColumn($alias . '.mt_description');
            $criteria->removeSelectColumn($alias . '.mt_keywords');
            $criteria->removeSelectColumn($alias . '.mt_robots');
            $criteria->removeSelectColumn($alias . '.seo_rule');
            $criteria->removeSelectColumn($alias . '.pgs_seo_fn');
            $criteria->removeSelectColumn($alias . '.datecreate');
            $criteria->removeSelectColumn($alias . '.dateupdate');
            $criteria->removeSelectColumn($alias . '.domain_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(PageTableMap::DATABASE_NAME)->getTable(PageTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Page or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Page object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\Page\Page) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(PageTableMap::DATABASE_NAME);
            $criteria->add(PageTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = PageQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            PageTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                PageTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _pages table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return PageQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Page or Criteria object.
     *
     * @param mixed $criteria Criteria or Page object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PageTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Page object
        }

        if ($criteria->containsKey(PageTableMap::COL_ID) && $criteria->keyContainsValue(PageTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.PageTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = PageQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
