<?php

namespace Diamond\Infrastructure\Models\MessageRequest\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\MessageRequest\MessageRequest as ChildMessageRequest;
use Diamond\Infrastructure\Models\MessageRequest\MessageRequestQuery as ChildMessageRequestQuery;
use Diamond\Infrastructure\Models\MessageRequest\Map\MessageRequestTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_message_requests' table.
 *
 *
 *
 * @method     ChildMessageRequestQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildMessageRequestQuery orderByEmailTo($order = Criteria::ASC) Order by the email_to column
 * @method     ChildMessageRequestQuery orderByEmailFrom($order = Criteria::ASC) Order by the email_from column
 * @method     ChildMessageRequestQuery orderBySubject($order = Criteria::ASC) Order by the subject column
 * @method     ChildMessageRequestQuery orderByBody($order = Criteria::ASC) Order by the body column
 * @method     ChildMessageRequestQuery orderByAttachments($order = Criteria::ASC) Order by the attachments column
 * @method     ChildMessageRequestQuery orderByCreatedAt($order = Criteria::ASC) Order by the created_at column
 * @method     ChildMessageRequestQuery orderByStatus($order = Criteria::ASC) Order by the status column
 *
 * @method     ChildMessageRequestQuery groupById() Group by the id column
 * @method     ChildMessageRequestQuery groupByEmailTo() Group by the email_to column
 * @method     ChildMessageRequestQuery groupByEmailFrom() Group by the email_from column
 * @method     ChildMessageRequestQuery groupBySubject() Group by the subject column
 * @method     ChildMessageRequestQuery groupByBody() Group by the body column
 * @method     ChildMessageRequestQuery groupByAttachments() Group by the attachments column
 * @method     ChildMessageRequestQuery groupByCreatedAt() Group by the created_at column
 * @method     ChildMessageRequestQuery groupByStatus() Group by the status column
 *
 * @method     ChildMessageRequestQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildMessageRequestQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildMessageRequestQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildMessageRequestQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildMessageRequestQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildMessageRequestQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildMessageRequest|null findOne(?ConnectionInterface $con = null) Return the first ChildMessageRequest matching the query
 * @method     ChildMessageRequest findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildMessageRequest matching the query, or a new ChildMessageRequest object populated from the query conditions when no match is found
 *
 * @method     ChildMessageRequest|null findOneById(int $id) Return the first ChildMessageRequest filtered by the id column
 * @method     ChildMessageRequest|null findOneByEmailTo(string $email_to) Return the first ChildMessageRequest filtered by the email_to column
 * @method     ChildMessageRequest|null findOneByEmailFrom(string $email_from) Return the first ChildMessageRequest filtered by the email_from column
 * @method     ChildMessageRequest|null findOneBySubject(string $subject) Return the first ChildMessageRequest filtered by the subject column
 * @method     ChildMessageRequest|null findOneByBody(string $body) Return the first ChildMessageRequest filtered by the body column
 * @method     ChildMessageRequest|null findOneByAttachments(string $attachments) Return the first ChildMessageRequest filtered by the attachments column
 * @method     ChildMessageRequest|null findOneByCreatedAt(string $created_at) Return the first ChildMessageRequest filtered by the created_at column
 * @method     ChildMessageRequest|null findOneByStatus(string $status) Return the first ChildMessageRequest filtered by the status column *

 * @method     ChildMessageRequest requirePk($key, ?ConnectionInterface $con = null) Return the ChildMessageRequest by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOne(?ConnectionInterface $con = null) Return the first ChildMessageRequest matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMessageRequest requireOneById(int $id) Return the first ChildMessageRequest filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByEmailTo(string $email_to) Return the first ChildMessageRequest filtered by the email_to column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByEmailFrom(string $email_from) Return the first ChildMessageRequest filtered by the email_from column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneBySubject(string $subject) Return the first ChildMessageRequest filtered by the subject column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByBody(string $body) Return the first ChildMessageRequest filtered by the body column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByAttachments(string $attachments) Return the first ChildMessageRequest filtered by the attachments column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByCreatedAt(string $created_at) Return the first ChildMessageRequest filtered by the created_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildMessageRequest requireOneByStatus(string $status) Return the first ChildMessageRequest filtered by the status column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildMessageRequest[]|Collection find(?ConnectionInterface $con = null) Return ChildMessageRequest objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildMessageRequest> find(?ConnectionInterface $con = null) Return ChildMessageRequest objects based on current ModelCriteria
 * @method     ChildMessageRequest[]|Collection findById(int $id) Return ChildMessageRequest objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findById(int $id) Return ChildMessageRequest objects filtered by the id column
 * @method     ChildMessageRequest[]|Collection findByEmailTo(string $email_to) Return ChildMessageRequest objects filtered by the email_to column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByEmailTo(string $email_to) Return ChildMessageRequest objects filtered by the email_to column
 * @method     ChildMessageRequest[]|Collection findByEmailFrom(string $email_from) Return ChildMessageRequest objects filtered by the email_from column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByEmailFrom(string $email_from) Return ChildMessageRequest objects filtered by the email_from column
 * @method     ChildMessageRequest[]|Collection findBySubject(string $subject) Return ChildMessageRequest objects filtered by the subject column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findBySubject(string $subject) Return ChildMessageRequest objects filtered by the subject column
 * @method     ChildMessageRequest[]|Collection findByBody(string $body) Return ChildMessageRequest objects filtered by the body column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByBody(string $body) Return ChildMessageRequest objects filtered by the body column
 * @method     ChildMessageRequest[]|Collection findByAttachments(string $attachments) Return ChildMessageRequest objects filtered by the attachments column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByAttachments(string $attachments) Return ChildMessageRequest objects filtered by the attachments column
 * @method     ChildMessageRequest[]|Collection findByCreatedAt(string $created_at) Return ChildMessageRequest objects filtered by the created_at column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByCreatedAt(string $created_at) Return ChildMessageRequest objects filtered by the created_at column
 * @method     ChildMessageRequest[]|Collection findByStatus(string $status) Return ChildMessageRequest objects filtered by the status column
 * @psalm-method Collection&\Traversable<ChildMessageRequest> findByStatus(string $status) Return ChildMessageRequest objects filtered by the status column
 * @method     ChildMessageRequest[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildMessageRequest> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class MessageRequestQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\MessageRequest\Base\MessageRequestQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\MessageRequest\\MessageRequest', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildMessageRequestQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildMessageRequestQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildMessageRequestQuery) {
            return $criteria;
        }
        $query = new ChildMessageRequestQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildMessageRequest|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(MessageRequestTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = MessageRequestTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildMessageRequest A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `email_to`, `email_from`, `subject`, `body`, `attachments`, `created_at`, `status` FROM `_message_requests` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildMessageRequest $obj */
            $obj = new ChildMessageRequest();
            $obj->hydrate($row);
            MessageRequestTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildMessageRequest|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(MessageRequestTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(MessageRequestTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(MessageRequestTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(MessageRequestTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the email_to column
     *
     * Example usage:
     * <code>
     * $query->filterByEmailTo('fooValue');   // WHERE email_to = 'fooValue'
     * $query->filterByEmailTo('%fooValue%', Criteria::LIKE); // WHERE email_to LIKE '%fooValue%'
     * $query->filterByEmailTo(['foo', 'bar']); // WHERE email_to IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $emailTo The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByEmailTo($emailTo = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($emailTo)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_EMAIL_TO, $emailTo, $comparison);

        return $this;
    }

    /**
     * Filter the query on the email_from column
     *
     * Example usage:
     * <code>
     * $query->filterByEmailFrom('fooValue');   // WHERE email_from = 'fooValue'
     * $query->filterByEmailFrom('%fooValue%', Criteria::LIKE); // WHERE email_from LIKE '%fooValue%'
     * $query->filterByEmailFrom(['foo', 'bar']); // WHERE email_from IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $emailFrom The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByEmailFrom($emailFrom = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($emailFrom)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_EMAIL_FROM, $emailFrom, $comparison);

        return $this;
    }

    /**
     * Filter the query on the subject column
     *
     * Example usage:
     * <code>
     * $query->filterBySubject('fooValue');   // WHERE subject = 'fooValue'
     * $query->filterBySubject('%fooValue%', Criteria::LIKE); // WHERE subject LIKE '%fooValue%'
     * $query->filterBySubject(['foo', 'bar']); // WHERE subject IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $subject The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterBySubject($subject = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($subject)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_SUBJECT, $subject, $comparison);

        return $this;
    }

    /**
     * Filter the query on the body column
     *
     * Example usage:
     * <code>
     * $query->filterByBody('fooValue');   // WHERE body = 'fooValue'
     * $query->filterByBody('%fooValue%', Criteria::LIKE); // WHERE body LIKE '%fooValue%'
     * $query->filterByBody(['foo', 'bar']); // WHERE body IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $body The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByBody($body = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($body)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_BODY, $body, $comparison);

        return $this;
    }

    /**
     * Filter the query on the attachments column
     *
     * Example usage:
     * <code>
     * $query->filterByAttachments('fooValue');   // WHERE attachments = 'fooValue'
     * $query->filterByAttachments('%fooValue%', Criteria::LIKE); // WHERE attachments LIKE '%fooValue%'
     * $query->filterByAttachments(['foo', 'bar']); // WHERE attachments IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $attachments The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByAttachments($attachments = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($attachments)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_ATTACHMENTS, $attachments, $comparison);

        return $this;
    }

    /**
     * Filter the query on the created_at column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatedAt('2011-03-14'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt('now'); // WHERE created_at = '2011-03-14'
     * $query->filterByCreatedAt(array('max' => 'yesterday')); // WHERE created_at > '2011-03-13'
     * </code>
     *
     * @param mixed $createdAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreatedAt($createdAt = null, ?string $comparison = null)
    {
        if (is_array($createdAt)) {
            $useMinMax = false;
            if (isset($createdAt['min'])) {
                $this->addUsingAlias(MessageRequestTableMap::COL_CREATED_AT, $createdAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($createdAt['max'])) {
                $this->addUsingAlias(MessageRequestTableMap::COL_CREATED_AT, $createdAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_CREATED_AT, $createdAt, $comparison);

        return $this;
    }

    /**
     * Filter the query on the status column
     *
     * Example usage:
     * <code>
     * $query->filterByStatus('fooValue');   // WHERE status = 'fooValue'
     * $query->filterByStatus('%fooValue%', Criteria::LIKE); // WHERE status LIKE '%fooValue%'
     * $query->filterByStatus(['foo', 'bar']); // WHERE status IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $status The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByStatus($status = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($status)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(MessageRequestTableMap::COL_STATUS, $status, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildMessageRequest $messageRequest Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($messageRequest = null)
    {
        if ($messageRequest) {
            $this->addUsingAlias(MessageRequestTableMap::COL_ID, $messageRequest->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _message_requests table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MessageRequestTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            MessageRequestTableMap::clearInstancePool();
            MessageRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MessageRequestTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(MessageRequestTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            MessageRequestTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            MessageRequestTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
