<?php

namespace Diamond\Infrastructure\Models\Mailing;

use Diamond\Domain\MailingList\Concrete\MailingListEntityInterface;
use Diamond\Domain\MailingList\ProgressData;
use Diamond\Infrastructure\Models\Mailing\Base\Mailing as BaseMailing;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequestQuery;
use Propel\Runtime\ActiveQuery\Criteria;

/**
 * Skeleton subclass for representing a row from the '_mailing' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class Mailing extends BaseMailing implements MailingListEntityInterface
{
    /**
     * @var ProgressData|null
     */
    private $progressData;

    public function getProgressData(): ?ProgressData
    {
        return $this->progressData;
    }

    /**
     * @param ProgressData $progressData
     * @return Mailing
     */
    public function setProgressData(ProgressData $progressData): Mailing
    {
        $this->progressData = $progressData;
        return $this;
    }

    public function completed(): void
    {
        $request = MailingRequestQuery::create()
            ->filterByMailingId($this->getId())
            ->filterByCompleted(0)
            ->orderByCreatedAt(Criteria::DESC)
            ->findOne();
        if ($request) {
            $request->setCompleted(1);
            $request->save();
        }
    }
}
