<?php

namespace Diamond\Infrastructure\Models\CasbinRule\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\CasbinRule\CasbinRule as ChildCasbinRule;
use Diamond\Infrastructure\Models\CasbinRule\CasbinRuleQuery as ChildCasbinRuleQuery;
use Diamond\Infrastructure\Models\CasbinRule\Map\CasbinRuleTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_casbin_rule' table.
 *
 *
 *
 * @method     ChildCasbinRuleQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildCasbinRuleQuery orderByPtype($order = Criteria::ASC) Order by the ptype column
 * @method     ChildCasbinRuleQuery orderByV0($order = Criteria::ASC) Order by the v0 column
 * @method     ChildCasbinRuleQuery orderByV1($order = Criteria::ASC) Order by the v1 column
 * @method     ChildCasbinRuleQuery orderByV2($order = Criteria::ASC) Order by the v2 column
 * @method     ChildCasbinRuleQuery orderByV3($order = Criteria::ASC) Order by the v3 column
 * @method     ChildCasbinRuleQuery orderByV4($order = Criteria::ASC) Order by the v4 column
 * @method     ChildCasbinRuleQuery orderByV5($order = Criteria::ASC) Order by the v5 column
 *
 * @method     ChildCasbinRuleQuery groupById() Group by the id column
 * @method     ChildCasbinRuleQuery groupByPtype() Group by the ptype column
 * @method     ChildCasbinRuleQuery groupByV0() Group by the v0 column
 * @method     ChildCasbinRuleQuery groupByV1() Group by the v1 column
 * @method     ChildCasbinRuleQuery groupByV2() Group by the v2 column
 * @method     ChildCasbinRuleQuery groupByV3() Group by the v3 column
 * @method     ChildCasbinRuleQuery groupByV4() Group by the v4 column
 * @method     ChildCasbinRuleQuery groupByV5() Group by the v5 column
 *
 * @method     ChildCasbinRuleQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildCasbinRuleQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildCasbinRuleQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildCasbinRuleQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildCasbinRuleQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildCasbinRuleQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildCasbinRule|null findOne(?ConnectionInterface $con = null) Return the first ChildCasbinRule matching the query
 * @method     ChildCasbinRule findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildCasbinRule matching the query, or a new ChildCasbinRule object populated from the query conditions when no match is found
 *
 * @method     ChildCasbinRule|null findOneById(int $id) Return the first ChildCasbinRule filtered by the id column
 * @method     ChildCasbinRule|null findOneByPtype(string $ptype) Return the first ChildCasbinRule filtered by the ptype column
 * @method     ChildCasbinRule|null findOneByV0(string $v0) Return the first ChildCasbinRule filtered by the v0 column
 * @method     ChildCasbinRule|null findOneByV1(string $v1) Return the first ChildCasbinRule filtered by the v1 column
 * @method     ChildCasbinRule|null findOneByV2(string $v2) Return the first ChildCasbinRule filtered by the v2 column
 * @method     ChildCasbinRule|null findOneByV3(string $v3) Return the first ChildCasbinRule filtered by the v3 column
 * @method     ChildCasbinRule|null findOneByV4(string $v4) Return the first ChildCasbinRule filtered by the v4 column
 * @method     ChildCasbinRule|null findOneByV5(string $v5) Return the first ChildCasbinRule filtered by the v5 column *

 * @method     ChildCasbinRule requirePk($key, ?ConnectionInterface $con = null) Return the ChildCasbinRule by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOne(?ConnectionInterface $con = null) Return the first ChildCasbinRule matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCasbinRule requireOneById(int $id) Return the first ChildCasbinRule filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByPtype(string $ptype) Return the first ChildCasbinRule filtered by the ptype column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV0(string $v0) Return the first ChildCasbinRule filtered by the v0 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV1(string $v1) Return the first ChildCasbinRule filtered by the v1 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV2(string $v2) Return the first ChildCasbinRule filtered by the v2 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV3(string $v3) Return the first ChildCasbinRule filtered by the v3 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV4(string $v4) Return the first ChildCasbinRule filtered by the v4 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildCasbinRule requireOneByV5(string $v5) Return the first ChildCasbinRule filtered by the v5 column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildCasbinRule[]|Collection find(?ConnectionInterface $con = null) Return ChildCasbinRule objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildCasbinRule> find(?ConnectionInterface $con = null) Return ChildCasbinRule objects based on current ModelCriteria
 * @method     ChildCasbinRule[]|Collection findById(int $id) Return ChildCasbinRule objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findById(int $id) Return ChildCasbinRule objects filtered by the id column
 * @method     ChildCasbinRule[]|Collection findByPtype(string $ptype) Return ChildCasbinRule objects filtered by the ptype column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByPtype(string $ptype) Return ChildCasbinRule objects filtered by the ptype column
 * @method     ChildCasbinRule[]|Collection findByV0(string $v0) Return ChildCasbinRule objects filtered by the v0 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV0(string $v0) Return ChildCasbinRule objects filtered by the v0 column
 * @method     ChildCasbinRule[]|Collection findByV1(string $v1) Return ChildCasbinRule objects filtered by the v1 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV1(string $v1) Return ChildCasbinRule objects filtered by the v1 column
 * @method     ChildCasbinRule[]|Collection findByV2(string $v2) Return ChildCasbinRule objects filtered by the v2 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV2(string $v2) Return ChildCasbinRule objects filtered by the v2 column
 * @method     ChildCasbinRule[]|Collection findByV3(string $v3) Return ChildCasbinRule objects filtered by the v3 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV3(string $v3) Return ChildCasbinRule objects filtered by the v3 column
 * @method     ChildCasbinRule[]|Collection findByV4(string $v4) Return ChildCasbinRule objects filtered by the v4 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV4(string $v4) Return ChildCasbinRule objects filtered by the v4 column
 * @method     ChildCasbinRule[]|Collection findByV5(string $v5) Return ChildCasbinRule objects filtered by the v5 column
 * @psalm-method Collection&\Traversable<ChildCasbinRule> findByV5(string $v5) Return ChildCasbinRule objects filtered by the v5 column
 * @method     ChildCasbinRule[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildCasbinRule> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class CasbinRuleQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\CasbinRule\Base\CasbinRuleQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\CasbinRule\\CasbinRule', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildCasbinRuleQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildCasbinRuleQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildCasbinRuleQuery) {
            return $criteria;
        }
        $query = new ChildCasbinRuleQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildCasbinRule|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CasbinRuleTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = CasbinRuleTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildCasbinRule A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `ptype`, `v0`, `v1`, `v2`, `v3`, `v4`, `v5` FROM `_casbin_rule` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildCasbinRule $obj */
            $obj = new ChildCasbinRule();
            $obj->hydrate($row);
            CasbinRuleTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildCasbinRule|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the ptype column
     *
     * Example usage:
     * <code>
     * $query->filterByPtype('fooValue');   // WHERE ptype = 'fooValue'
     * $query->filterByPtype('%fooValue%', Criteria::LIKE); // WHERE ptype LIKE '%fooValue%'
     * $query->filterByPtype(['foo', 'bar']); // WHERE ptype IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $ptype The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPtype($ptype = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($ptype)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_PTYPE, $ptype, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v0 column
     *
     * Example usage:
     * <code>
     * $query->filterByV0('fooValue');   // WHERE v0 = 'fooValue'
     * $query->filterByV0('%fooValue%', Criteria::LIKE); // WHERE v0 LIKE '%fooValue%'
     * $query->filterByV0(['foo', 'bar']); // WHERE v0 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v0 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV0($v0 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v0)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V0, $v0, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v1 column
     *
     * Example usage:
     * <code>
     * $query->filterByV1('fooValue');   // WHERE v1 = 'fooValue'
     * $query->filterByV1('%fooValue%', Criteria::LIKE); // WHERE v1 LIKE '%fooValue%'
     * $query->filterByV1(['foo', 'bar']); // WHERE v1 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v1 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV1($v1 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v1)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V1, $v1, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v2 column
     *
     * Example usage:
     * <code>
     * $query->filterByV2('fooValue');   // WHERE v2 = 'fooValue'
     * $query->filterByV2('%fooValue%', Criteria::LIKE); // WHERE v2 LIKE '%fooValue%'
     * $query->filterByV2(['foo', 'bar']); // WHERE v2 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v2 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV2($v2 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v2)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V2, $v2, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v3 column
     *
     * Example usage:
     * <code>
     * $query->filterByV3('fooValue');   // WHERE v3 = 'fooValue'
     * $query->filterByV3('%fooValue%', Criteria::LIKE); // WHERE v3 LIKE '%fooValue%'
     * $query->filterByV3(['foo', 'bar']); // WHERE v3 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v3 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV3($v3 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v3)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V3, $v3, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v4 column
     *
     * Example usage:
     * <code>
     * $query->filterByV4('fooValue');   // WHERE v4 = 'fooValue'
     * $query->filterByV4('%fooValue%', Criteria::LIKE); // WHERE v4 LIKE '%fooValue%'
     * $query->filterByV4(['foo', 'bar']); // WHERE v4 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v4 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV4($v4 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v4)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V4, $v4, $comparison);

        return $this;
    }

    /**
     * Filter the query on the v5 column
     *
     * Example usage:
     * <code>
     * $query->filterByV5('fooValue');   // WHERE v5 = 'fooValue'
     * $query->filterByV5('%fooValue%', Criteria::LIKE); // WHERE v5 LIKE '%fooValue%'
     * $query->filterByV5(['foo', 'bar']); // WHERE v5 IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $v5 The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByV5($v5 = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($v5)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(CasbinRuleTableMap::COL_V5, $v5, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildCasbinRule $casbinRule Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($casbinRule = null)
    {
        if ($casbinRule) {
            $this->addUsingAlias(CasbinRuleTableMap::COL_ID, $casbinRule->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _casbin_rule table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CasbinRuleTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            CasbinRuleTableMap::clearInstancePool();
            CasbinRuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CasbinRuleTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(CasbinRuleTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            CasbinRuleTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            CasbinRuleTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
