<?php

namespace Diamond\Domain\UserGroup;

use Core\Repository\DropDownInterface;
use Diamond\Domain\UserGroup\Contracts\UserGroupEntityInterface;
use Repo\Concrete\AbstractCollection;

class UserGroupCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return UserGroupEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getId()] = $entity->getName();
        }
        return $ar;
    }

}