<?php

namespace Diamond\Presentation\Modules\AdminTagsContents;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Diamond\Infrastructure\Models\ContentTag\ContentTag;
use Diamond\Repositories\ContentTag\ContentTagCriteria;
use Diamond\Repositories\ContentTag\ContentTagRepository;
use DiamondTable\TableFactory;


class AdminTagsContents extends ModuleController
{

    public function __construct(private ContentTagRepository $repo,
                                private ControlBuilder $controlBuilder,
                                private TableFactory $tableFactory)
    {}


    public function process(): string
    {
        $table = $this->tableFactory->buildAdminTable(
            $this->repo,
            ContentTagCriteria::create()
        );

        $table
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))
            )->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)->setFormat($this, 'formatActions')
            );

        $table
            ->addField($this->controlBuilder->buildInput('name'), true);

        return $table->render();
    }

    public function formatActions(ContentTag $tag): string
    {
        return $this->controlBuilder->buildActionMenuAdmin([], (int)$tag->getId())->render();
    }
}               